/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.autoconfigure;

import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.SentryOptions;
import io.sentry.config.Lookup;
import io.sentry.connection.EventSendCallback;
import io.sentry.event.helper.EventBuilderHelper;
import io.sentry.event.helper.ShouldSendEventCallback;
import io.sentry.spring.SentryExceptionResolver;
import io.sentry.spring.SentryServletContextInitializer;
import io.sentry.spring.autoconfigure.SentryProperties;
import io.sentry.spring.autoconfigure.SpringBootConfigurationProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerExceptionResolver;

@Configuration
@ConditionalOnClass(value={HandlerExceptionResolver.class, SentryExceptionResolver.class})
@EnableConfigurationProperties(value={SentryProperties.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(name={"sentry.enabled"}, havingValue="true", matchIfMissing=true)
public class SentryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SentryExceptionResolver.class})
    public HandlerExceptionResolver sentryExceptionResolver() {
        return new SentryExceptionResolver();
    }

    @Bean
    @ConditionalOnMissingBean(value={SentryServletContextInitializer.class})
    public ServletContextInitializer sentryServletContextInitializer() {
        return new SentryServletContextInitializer();
    }

    @Bean
    @ConditionalOnMissingBean(value={SentryClient.class})
    @ConditionalOnProperty(name={"sentry.init-default-client"}, havingValue="true", matchIfMissing=true)
    public SentryClient sentryClient(SentryProperties properties, @Autowired(required=false) List<EventBuilderHelper> eventBuilderHelpers, @Autowired(required=false) List<EventSendCallback> eventSendCallbacks, @Autowired(required=false) List<ShouldSendEventCallback> shouldSendEventCallbacks) {
        String dsn = properties.getDsn() != null ? properties.getDsn().toString() : null;
        SentryOptions sentryOptions = SentryOptions.from((Lookup)this.createLookup(properties), (String)dsn, null);
        SentryClient sentryClient = Sentry.init((SentryOptions)sentryOptions);
        if (!StringUtils.isEmpty((Object)properties.getRelease())) {
            sentryClient.setRelease(properties.getRelease());
        }
        if (!StringUtils.isEmpty((Object)properties.getDist())) {
            sentryClient.setDist(properties.getDist());
        }
        if (!StringUtils.isEmpty((Object)properties.getEnvironment())) {
            sentryClient.setEnvironment(properties.getEnvironment());
        }
        if (!StringUtils.isEmpty((Object)properties.getServerName())) {
            sentryClient.setServerName(properties.getServerName());
        }
        if (properties.getTags() != null && !properties.getTags().isEmpty()) {
            for (Map.Entry entry : properties.getTags().entrySet()) {
                sentryClient.addTag((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (properties.getMdcTags() != null && !properties.getMdcTags().isEmpty()) {
            for (String string : properties.getMdcTags()) {
                sentryClient.addMdcTag(string);
            }
        }
        if (properties.getExtra() != null && !properties.getExtra().isEmpty()) {
            for (Map.Entry entry : properties.getExtra().entrySet()) {
                sentryClient.addExtra((String)entry.getKey(), entry.getValue());
            }
        }
        if (eventBuilderHelpers != null && !eventBuilderHelpers.isEmpty()) {
            for (EventBuilderHelper eventBuilderHelper : eventBuilderHelpers) {
                sentryClient.addBuilderHelper(eventBuilderHelper);
            }
        }
        if (eventSendCallbacks != null && !eventSendCallbacks.isEmpty()) {
            for (EventSendCallback eventSendCallback : eventSendCallbacks) {
                sentryClient.addEventSendCallback(eventSendCallback);
            }
        }
        if (shouldSendEventCallbacks != null && !shouldSendEventCallbacks.isEmpty()) {
            for (ShouldSendEventCallback shouldSendEventCallback : shouldSendEventCallbacks) {
                sentryClient.addShouldSendEventCallback(shouldSendEventCallback);
            }
        }
        return sentryClient;
    }

    private Lookup createLookup(SentryProperties properties) {
        return Lookup.getDefaultWithAdditionalProviders(Collections.singletonList(new SpringBootConfigurationProvider(properties)), Collections.emptyList());
    }
}

