/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import io.seata.sqlparser.ParametersHolder;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.druid.BaseRecognizer;
import io.seata.sqlparser.struct.Null;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BaseMySQLRecognizer
extends BaseRecognizer {
    public BaseMySQLRecognizer(String originalSql) {
        super(originalSql);
    }

    public MySqlOutputVisitor createOutputVisitor(final ParametersHolder parametersHolder, final ArrayList<List<Object>> paramAppenderList, StringBuilder sb) {
        return new MySqlOutputVisitor(sb){

            public boolean visit(SQLVariantRefExpr x) {
                if ("?".equals(x.getName())) {
                    ArrayList oneParamValues = (ArrayList)parametersHolder.getParameters().get(x.getIndex() + 1);
                    if (paramAppenderList.isEmpty()) {
                        oneParamValues.forEach(t -> paramAppenderList.add(new ArrayList()));
                    }
                    for (int i = 0; i < oneParamValues.size(); ++i) {
                        Object o = oneParamValues.get(i);
                        ((List)paramAppenderList.get(i)).add(o instanceof Null ? null : (Object)o);
                    }
                }
                return super.visit(x);
            }
        };
    }

    public String getWhereCondition(SQLExpr where, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)this.createOutputVisitor(parametersHolder, paramAppenderList, sb));
        return sb.toString();
    }

    public String getWhereCondition(SQLExpr where) {
        if (Objects.isNull(where)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.executeVisit(where, (SQLASTVisitor)new MySqlOutputVisitor((Appendable)sb));
        return sb.toString();
    }

    protected String getLimit(SQLStatement sqlStatement, SQLType sqlType, ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        SQLLimit limit = null;
        if (SQLType.UPDATE == sqlType) {
            limit = ((MySqlUpdateStatement)sqlStatement).getLimit();
        } else if (SQLType.DELETE == sqlType) {
            limit = ((MySqlDeleteStatement)sqlStatement).getLimit();
        }
        if (limit != null) {
            SQLIntegerExpr expr;
            Map parameters;
            StringBuilder builder = new StringBuilder(" LIMIT ");
            if (limit.getOffset() != null) {
                if (limit.getOffset() instanceof SQLVariantRefExpr) {
                    builder.append("?,");
                    parameters = parametersHolder.getParameters();
                    paramAppenderList.add((List<Object>)parameters.get(parameters.size() - 1));
                } else {
                    expr = (SQLIntegerExpr)limit.getOffset();
                    builder.append(expr.getNumber()).append(",");
                }
            }
            if (limit.getRowCount() != null) {
                if (limit.getRowCount() instanceof SQLVariantRefExpr) {
                    builder.append("?");
                    parameters = parametersHolder.getParameters();
                    paramAppenderList.add((List<Object>)parameters.get(parameters.size()));
                } else {
                    expr = (SQLIntegerExpr)limit.getRowCount();
                    builder.append(expr.getNumber());
                }
            }
            return builder.toString();
        }
        return null;
    }

    protected String getOrderBy(SQLStatement sqlStatement, SQLType sqlType) {
        SQLOrderBy orderBy = null;
        if (SQLType.UPDATE == sqlType) {
            orderBy = ((MySqlUpdateStatement)sqlStatement).getOrderBy();
        } else if (SQLType.DELETE == sqlType) {
            orderBy = ((MySqlDeleteStatement)sqlStatement).getOrderBy();
        }
        if (orderBy != null) {
            String space = " ";
            String comma = ",";
            StringBuilder builder = new StringBuilder(space).append("ORDER BY").append(space);
            List items = orderBy.getItems();
            for (int i = 0; i < items.size(); ++i) {
                SQLSelectOrderByItem item = (SQLSelectOrderByItem)items.get(i);
                SQLIdentifierExpr expr = (SQLIdentifierExpr)item.getExpr();
                builder.append(expr.getName());
                SQLOrderingSpecification specification = item.getType();
                if (specification != null) {
                    builder.append(space);
                    builder.append(specification.name);
                }
                if (i + 1 == items.size()) continue;
                builder.append(comma);
            }
            return builder.toString();
        }
        return null;
    }
}

