/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import io.seata.sqlparser.druid.DruidLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;

class DefaultDruidLoader
implements DruidLoader {
    private static final String DRUID_LOCATION = "lib/sqlparser/druid.jar";
    private static final DefaultDruidLoader DRUID_LOADER = new DefaultDruidLoader("lib/sqlparser/druid.jar");
    private final URL druidUrl;

    private DefaultDruidLoader(String druidLocation) {
        URL url;
        if (druidLocation == null) {
            druidLocation = DRUID_LOCATION;
        }
        if ((url = DefaultDruidLoader.class.getClassLoader().getResource(druidLocation)) != null) {
            try {
                File tempFile = File.createTempFile("seata", "sqlparser");
                try (InputStream input = url.openStream();
                     FileOutputStream output = new FileOutputStream(tempFile);){
                    int readCnt;
                    byte[] buf = new byte[1024];
                    while ((readCnt = input.read(buf)) >= 0) {
                        ((OutputStream)output).write(buf, 0, readCnt);
                    }
                    output.flush();
                }
                tempFile.deleteOnExit();
                this.druidUrl = tempFile.toURI().toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> clazz = null;
        try {
            clazz = DefaultDruidLoader.class.getClassLoader().loadClass("com.alibaba.druid.util.StringUtils");
        }
        catch (ClassNotFoundException input) {
            // empty catch block
        }
        if (clazz != null) {
            CodeSource cs = clazz.getProtectionDomain().getCodeSource();
            if (cs == null) {
                throw new IllegalStateException("Can not find druid code source");
            }
            this.druidUrl = cs.getLocation();
        } else {
            this.druidUrl = null;
        }
    }

    static DruidLoader get() {
        return DRUID_LOADER;
    }

    @Override
    public URL getEmbeddedDruidLocation() {
        if (this.druidUrl == null) {
            throw new IllegalStateException("Can not find embedded druid");
        }
        return this.druidUrl;
    }
}

