/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.util.Pool;
import io.seata.core.serializer.SerializerSecurityRegistry;
import io.seata.serializer.kryo.KryoInnerSerializer;

public class KryoSerializerFactory {
    private static final KryoSerializerFactory FACTORY = new KryoSerializerFactory();
    private Pool<Kryo> pool = new Pool<Kryo>(true, true){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setReferences(true);
            kryo.setRegistrationRequired(true);
            SerializerSecurityRegistry.getAllowClassType().forEach(arg_0 -> ((Kryo)kryo).register(arg_0));
            return kryo;
        }
    };

    private KryoSerializerFactory() {
    }

    public static KryoSerializerFactory getInstance() {
        return FACTORY;
    }

    public KryoInnerSerializer get() {
        return new KryoInnerSerializer((Kryo)this.pool.obtain());
    }

    public void returnKryo(KryoInnerSerializer kryoSerializer) {
        if (kryoSerializer == null) {
            throw new IllegalArgumentException("kryoSerializer is null");
        }
        this.pool.free((Object)kryoSerializer.getKryo());
    }
}

