/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.config;

import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.saga.engine.impl.DefaultStateMachineConfig;
import io.seata.saga.engine.serializer.impl.ParamsSerializer;
import io.seata.saga.engine.store.db.DbAndReportTcStateLogStore;
import io.seata.saga.engine.store.db.DbStateLangStore;
import io.seata.saga.tm.DefaultSagaTransactionalTemplate;
import io.seata.saga.tm.SagaTransactionalTemplate;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.StringUtils;

public class DbStateMachineConfig
extends DefaultStateMachineConfig
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbStateMachineConfig.class);
    private DataSource dataSource;
    private String applicationId;
    private String txServiceGroup;
    private String tablePrefix = "seata_";
    private String dbType;
    private SagaTransactionalTemplate sagaTransactionalTemplate;
    private boolean rmReportSuccessEnable = false;
    private boolean sagaBranchRegisterEnable = false;

    public DbStateMachineConfig() {
        try {
            Configuration configuration = ConfigurationFactory.getInstance();
            if (configuration != null) {
                this.rmReportSuccessEnable = configuration.getBoolean("client.rm.reportSuccessEnable", false);
                this.sagaBranchRegisterEnable = configuration.getBoolean("client.rm.sagaBranchRegisterEnable", false);
                this.setSagaJsonParser(configuration.getConfig("client.rm.sagaJsonParser", "fastjson"));
                this.applicationId = configuration.getConfig("applicationId");
                this.txServiceGroup = configuration.getConfig("txServiceGroup");
                this.setSagaRetryPersistModeUpdate(configuration.getBoolean("client.rm.sagaRetryPersistModeUpdate", false));
                this.setSagaCompensatePersistModeUpdate(configuration.getBoolean("client.rm.sagaCompensatePersistModeUpdate", false));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Load SEATA configuration failed, use default configuration instead.", (Throwable)e);
        }
    }

    public static String getDbTypeFromDataSource(DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.dbType = DbStateMachineConfig.getDbTypeFromDataSource(this.dataSource);
        if (this.getStateLogStore() == null) {
            DbAndReportTcStateLogStore dbStateLogStore = new DbAndReportTcStateLogStore();
            dbStateLogStore.setDataSource(this.dataSource);
            dbStateLogStore.setTablePrefix(this.tablePrefix);
            dbStateLogStore.setDbType(this.dbType);
            dbStateLogStore.setDefaultTenantId(this.getDefaultTenantId());
            dbStateLogStore.setSeqGenerator(this.getSeqGenerator());
            if (StringUtils.hasLength((String)this.getSagaJsonParser())) {
                ParamsSerializer paramsSerializer = new ParamsSerializer();
                paramsSerializer.setJsonParserName(this.getSagaJsonParser());
                dbStateLogStore.setParamsSerializer(paramsSerializer);
            }
            if (this.sagaTransactionalTemplate == null) {
                DefaultSagaTransactionalTemplate defaultSagaTransactionalTemplate = new DefaultSagaTransactionalTemplate();
                defaultSagaTransactionalTemplate.setApplicationContext(this.getApplicationContext());
                defaultSagaTransactionalTemplate.setApplicationId(this.applicationId);
                defaultSagaTransactionalTemplate.setTxServiceGroup(this.txServiceGroup);
                defaultSagaTransactionalTemplate.afterPropertiesSet();
                this.sagaTransactionalTemplate = defaultSagaTransactionalTemplate;
            }
            dbStateLogStore.setSagaTransactionalTemplate(this.sagaTransactionalTemplate);
            this.setStateLogStore(dbStateLogStore);
        }
        if (this.getStateLangStore() == null) {
            DbStateLangStore dbStateLangStore = new DbStateLangStore();
            dbStateLangStore.setDataSource(this.dataSource);
            dbStateLangStore.setTablePrefix(this.tablePrefix);
            dbStateLangStore.setDbType(this.dbType);
            this.setStateLangStore(dbStateLangStore);
        }
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        if (this.sagaTransactionalTemplate != null && this.sagaTransactionalTemplate instanceof DisposableBean) {
            ((DisposableBean)this.sagaTransactionalTemplate).destroy();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public void setTxServiceGroup(String txServiceGroup) {
        this.txServiceGroup = txServiceGroup;
    }

    public void setSagaTransactionalTemplate(SagaTransactionalTemplate sagaTransactionalTemplate) {
        this.sagaTransactionalTemplate = sagaTransactionalTemplate;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public boolean isRmReportSuccessEnable() {
        return this.rmReportSuccessEnable;
    }

    public boolean isSagaBranchRegisterEnable() {
        return this.sagaBranchRegisterEnable;
    }

    public void setSagaBranchRegisterEnable(boolean sagaBranchRegisterEnable) {
        this.sagaBranchRegisterEnable = sagaBranchRegisterEnable;
    }

    public void setRmReportSuccessEnable(boolean rmReportSuccessEnable) {
        this.rmReportSuccessEnable = rmReportSuccessEnable;
    }
}

