/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.sqlserver;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.SqlGenerateUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.undo.sqlserver.BaseSqlServerUndoExecutor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SqlServerUndoInsertExecutor
extends BaseSqlServerUndoExecutor {
    public SqlServerUndoInsertExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        TableRecords afterImage = this.sqlUndoLog.getAfterImage();
        List<Row> afterImageRows = afterImage.getRows();
        if (CollectionUtils.isEmpty(afterImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        return this.generateDeleteSql(afterImageRows, afterImage);
    }

    private String generateDeleteSql(List<Row> rows, TableRecords afterImage) {
        List<String> pkNameList = this.getOrderedPkList(afterImage, rows.get(0), "sqlserver").stream().map(Field::getName).collect(Collectors.toList());
        String whereSql = SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, "sqlserver");
        return "DELETE FROM " + this.sqlUndoLog.getTableName() + " WHERE " + whereSql;
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getAfterImage();
    }

    @Override
    protected void undoPrepare(PreparedStatement undoPST, ArrayList<Field> undoValues, List<Field> pkValueList) throws SQLException {
        int undoIndex = 0;
        for (Field pkField : pkValueList) {
            undoPST.setObject(++undoIndex, pkField.getValue(), pkField.getType());
        }
    }
}

