/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.undo.UndoLogConstants;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UndoLogParserFactory {
    private static final ConcurrentMap<String, UndoLogParser> INSTANCES = new ConcurrentHashMap<String, UndoLogParser>();

    private UndoLogParserFactory() {
    }

    public static UndoLogParser getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static UndoLogParser getInstance(String name) {
        if (StringUtils.equalsIgnoreCase((String)"fst", (String)name)) {
            throw new IllegalArgumentException("Since fst is no longer maintained, this serialization extension has been removed from version 2.0 for security and stability reasons.");
        }
        return (UndoLogParser)CollectionUtils.computeIfAbsent(INSTANCES, (Object)name, key -> (UndoLogParser)EnhancedServiceLoader.load(UndoLogParser.class, (String)name));
    }

    private static class SingletonHolder {
        private static final UndoLogParser INSTANCE = UndoLogParserFactory.getInstance(UndoLogConstants.DEFAULT_SERIALIZER);

        private SingletonHolder() {
        }
    }
}

