/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct.cache;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.sql.struct.cache.AbstractTableMetaCache;
import io.seata.sqlparser.struct.ColumnMeta;
import io.seata.sqlparser.struct.IndexMeta;
import io.seata.sqlparser.struct.IndexType;
import io.seata.sqlparser.struct.TableMeta;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="sqlserver")
public class SqlServerTableMetaCache
extends AbstractTableMetaCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerTableMetaCache.class);

    @Override
    protected String getCacheKey(Connection connection, String tableName, String resourceId) {
        DatabaseMetaData databaseMetaData;
        StringBuilder cacheKey = new StringBuilder(resourceId);
        cacheKey.append(".");
        String[] tableNameWithSchema = tableName.split("\\.");
        String defaultTableName = tableNameWithSchema[tableNameWithSchema.length - 1];
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException e) {
            LOGGER.error("Could not get connection, use default cache key {}", (Object)e.getMessage(), (Object)e);
            return cacheKey.append(defaultTableName).toString();
        }
        try {
            if (databaseMetaData.supportsMixedCaseIdentifiers()) {
                cacheKey.append(defaultTableName);
            } else {
                cacheKey.append(defaultTableName.toUpperCase());
            }
        }
        catch (SQLException e) {
            LOGGER.error("Could not get supportsMixedCaseIdentifiers in connection metadata, use default cache key {}", (Object)e.getMessage(), (Object)e);
            return cacheKey.append(defaultTableName).toString();
        }
        return cacheKey.toString();
    }

    @Override
    protected TableMeta fetchSchema(Connection connection, String tableName) throws SQLException {
        try {
            return this.resultSetMetaToSchema(connection, tableName);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e) {
            throw new SQLException(String.format("Failed to fetch schema of %s", tableName), e);
        }
    }

    private TableMeta resultSetMetaToSchema(Connection connection, String tableName) throws SQLException {
        TableMeta tm = new TableMeta();
        tm.setTableName(tableName);
        tableName = ColumnUtils.delEscape((String)tableName, (String)"sqlserver");
        String[] schemaTable = tableName.split("\\.");
        String catalogName = "";
        String schemaName = "";
        if (schemaTable.length > 2) {
            catalogName = schemaTable[schemaTable.length - 3];
        } else if (schemaTable.length > 1) {
            schemaName = schemaTable[schemaTable.length - 2];
        }
        if (StringUtils.isBlank((String)catalogName)) {
            catalogName = connection.getCatalog();
        }
        if (StringUtils.isBlank((String)schemaName)) {
            schemaName = connection.getSchema();
        }
        String pureTableName = schemaTable[schemaTable.length - 1];
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet rsColumns = metaData.getColumns(catalogName, schemaName, pureTableName, "%");
             ResultSet rsIndex = metaData.getIndexInfo(catalogName, schemaName, pureTableName, false, true);
             ResultSet rsPrimary = metaData.getPrimaryKeys(catalogName, schemaName, pureTableName);){
            while (rsColumns.next()) {
                ColumnMeta col = new ColumnMeta();
                col.setTableCat(rsColumns.getString("TABLE_CAT"));
                col.setTableSchemaName(rsColumns.getString("TABLE_SCHEM"));
                col.setTableName(rsColumns.getString("TABLE_NAME"));
                col.setColumnName(rsColumns.getString("COLUMN_NAME"));
                col.setDataType(rsColumns.getInt("DATA_TYPE"));
                col.setDataTypeName(rsColumns.getString("TYPE_NAME"));
                col.setColumnSize(rsColumns.getInt("COLUMN_SIZE"));
                col.setDecimalDigits(rsColumns.getInt("DECIMAL_DIGITS"));
                col.setNumPrecRadix(rsColumns.getInt("NUM_PREC_RADIX"));
                col.setNullAble(rsColumns.getInt("NULLABLE"));
                col.setRemarks(rsColumns.getString("REMARKS"));
                col.setColumnDef(rsColumns.getString("COLUMN_DEF"));
                col.setSqlDataType(rsColumns.getInt("SQL_DATA_TYPE"));
                col.setSqlDatetimeSub(rsColumns.getInt("SQL_DATETIME_SUB"));
                col.setCharOctetLength((Object)rsColumns.getInt("CHAR_OCTET_LENGTH"));
                col.setOrdinalPosition(rsColumns.getInt("ORDINAL_POSITION"));
                col.setIsNullAble(rsColumns.getString("IS_NULLABLE"));
                col.setIsAutoincrement(rsColumns.getString("IS_AUTOINCREMENT"));
                if (tm.getAllColumns().containsKey(col.getColumnName())) {
                    throw new NotSupportYetException("Not support the table has the same column name with different case yet");
                }
                tm.getAllColumns().put(col.getColumnName(), col);
            }
            while (rsIndex.next()) {
                IndexMeta index;
                String indexName = rsIndex.getString("INDEX_NAME");
                if (StringUtils.isNullOrEmpty((String)indexName)) continue;
                String colName = rsIndex.getString("COLUMN_NAME");
                ColumnMeta col = (ColumnMeta)tm.getAllColumns().get(colName);
                if (tm.getAllIndexes().containsKey(indexName)) {
                    index = (IndexMeta)tm.getAllIndexes().get(indexName);
                    index.getValues().add(col);
                    continue;
                }
                index = new IndexMeta();
                index.setIndexName(indexName);
                index.setNonUnique(rsIndex.getBoolean("NON_UNIQUE"));
                index.setIndexQualifier(rsIndex.getString("INDEX_QUALIFIER"));
                index.setIndexName(rsIndex.getString("INDEX_NAME"));
                index.setType(rsIndex.getShort("TYPE"));
                index.setOrdinalPosition((int)rsIndex.getShort("ORDINAL_POSITION"));
                index.setAscOrDesc(rsIndex.getString("ASC_OR_DESC"));
                index.setCardinality((long)rsIndex.getInt("CARDINALITY"));
                index.getValues().add(col);
                if (!index.isNonUnique()) {
                    index.setIndextype(IndexType.UNIQUE);
                } else {
                    index.setIndextype(IndexType.NORMAL);
                }
                tm.getAllIndexes().put(indexName, index);
            }
            while (rsPrimary.next()) {
                String pkIndexName = rsPrimary.getString("PK_NAME");
                if (!tm.getAllIndexes().containsKey(pkIndexName)) continue;
                IndexMeta index = (IndexMeta)tm.getAllIndexes().get(pkIndexName);
                index.setIndextype(IndexType.PRIMARY);
            }
            if (tm.getAllIndexes().isEmpty()) {
                throw new ShouldNeverHappenException(String.format("Could not found any index in the table: %s", tableName));
            }
        }
        return tm;
    }
}

