/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.sqlparser.struct.TableMetaCache;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaCacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableMetaCacheFactory.class);
    private static final Map<String, TableMetaCache> TABLE_META_CACHE_MAP = new ConcurrentHashMap<String, TableMetaCache>();
    private static final Map<String, TableMetaRefreshHolder> TABLE_META_REFRESH_HOLDER_MAP = new ConcurrentHashMap<String, TableMetaRefreshHolder>();
    private static final long TABLE_META_REFRESH_INTERVAL_TIME = 1000L;
    private static final int MAX_QUEUE_SIZE = 2000;
    private static boolean ENABLE_TABLE_META_CHECKER_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.rm.tableMetaCheckEnable", true);
    private static final long TABLE_META_CHECKER_INTERVAL = ConfigurationFactory.getInstance().getLong("client.rm.tableMetaCheckerInterval", 60000L);

    public static TableMetaCache getTableMetaCache(String dbType) {
        return (TableMetaCache)CollectionUtils.computeIfAbsent(TABLE_META_CACHE_MAP, (Object)dbType, key -> (TableMetaCache)EnhancedServiceLoader.load(TableMetaCache.class, (String)dbType));
    }

    public static void registerTableMeta(DataSourceProxy dataSourceProxy) {
        TableMetaRefreshHolder holder = new TableMetaRefreshHolder(dataSourceProxy);
        TABLE_META_REFRESH_HOLDER_MAP.put(dataSourceProxy.getResourceId(), holder);
    }

    public static void tableMetaRefreshEvent(String resourceId) {
        TableMetaRefreshHolder refreshHolder = TABLE_META_REFRESH_HOLDER_MAP.get(resourceId);
        boolean offer = refreshHolder.tableMetaRefreshQueue.offer(System.currentTimeMillis());
        if (!offer) {
            LOGGER.error("table refresh event offer error:{}", (Object)resourceId);
        }
    }

    static class TableMetaRefreshHolder {
        private long lastRefreshFinishTime;
        private DataSourceProxy dataSource;
        private BlockingQueue<Long> tableMetaRefreshQueue;
        private final Executor tableMetaRefreshExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("tableMetaRefresh", 1, true));

        TableMetaRefreshHolder(DataSourceProxy dataSource) {
            this.dataSource = dataSource;
            this.lastRefreshFinishTime = System.currentTimeMillis() - 1000L;
            this.tableMetaRefreshQueue = new LinkedBlockingQueue<Long>(2000);
            this.tableMetaRefreshExecutor.execute(() -> {
                while (true) {
                    if (ENABLE_TABLE_META_CHECKER_ENABLE && System.currentTimeMillis() - this.lastRefreshFinishTime > TABLE_META_CHECKER_INTERVAL) {
                        TableMetaCacheFactory.tableMetaRefreshEvent(dataSource.getResourceId());
                    }
                    try {
                        Long eventTime = this.tableMetaRefreshQueue.take();
                        if (eventTime - this.lastRefreshFinishTime <= 1000L) continue;
                        try (ConnectionProxy connection = dataSource.getConnection();){
                            TableMetaCache tableMetaCache = TableMetaCacheFactory.getTableMetaCache(dataSource.getDbType());
                            tableMetaCache.refresh((Connection)connection, dataSource.getResourceId());
                        }
                        this.lastRefreshFinishTime = System.currentTimeMillis();
                        continue;
                    }
                    catch (Exception exx) {
                        LOGGER.error("table refresh error:{}", (Object)exx.getMessage(), (Object)exx);
                        continue;
                    }
                    break;
                }
            });
        }
    }
}

