/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.AbstractDataSourceProxy;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import io.seata.rm.datasource.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceProxy.class);
    private static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT";
    private String resourceGroupId;
    private String jdbcUrl;
    private String dbType;
    private String userName;
    private static boolean ENABLE_TABLE_META_CHECKER_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.rm.tableMetaCheckEnable", false);
    private static final long TABLE_META_CHECKER_INTERVAL = ConfigurationFactory.getInstance().getLong("client.rm.tableMetaCheckerInterval", 60000L);
    private final ScheduledExecutorService tableMetaExcutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("tableMetaChecker", 1, true));

    public DataSourceProxy(DataSource targetDataSource) {
        this(targetDataSource, DEFAULT_RESOURCE_GROUP_ID);
    }

    public DataSourceProxy(DataSource targetDataSource, String resourceGroupId) {
        if (targetDataSource instanceof SeataDataSourceProxy) {
            LOGGER.info("Unwrap the target data source, because the type is: {}", (Object)targetDataSource.getClass().getName());
            targetDataSource = ((SeataDataSourceProxy)targetDataSource).getTargetDataSource();
        }
        this.targetDataSource = targetDataSource;
        this.init(targetDataSource, resourceGroupId);
    }

    private void init(DataSource dataSource, String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType(this.jdbcUrl);
            if ("oracle".equals(this.dbType)) {
                this.userName = connection.getMetaData().getUserName();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
        DefaultResourceManager.get().registerResource((Resource)this);
        if (ENABLE_TABLE_META_CHECKER_ENABLE) {
            this.tableMetaExcutor.scheduleAtFixedRate(() -> {
                try (Connection connection = dataSource.getConnection();){
                    TableMetaCacheFactory.getTableMetaCache(this.getDbType()).refresh(connection, this.getResourceId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 0L, TABLE_META_CHECKER_INTERVAL, TimeUnit.MILLISECONDS);
        }
        RootContext.setDefaultBranchType((BranchType)this.getBranchType());
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getResourceId() {
        if ("postgresql".equals(this.dbType)) {
            return this.getPGResourceId();
        }
        if ("oracle".equals(this.dbType) && this.userName != null) {
            return this.getDefaultResourceId() + "/" + this.userName;
        }
        return this.getDefaultResourceId();
    }

    private String getDefaultResourceId() {
        if (this.jdbcUrl.contains("?")) {
            return this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63));
        }
        return this.jdbcUrl;
    }

    private String getPGResourceId() {
        if (this.jdbcUrl.contains("?")) {
            String[] urlParams;
            StringBuilder jdbcUrlBuilder = new StringBuilder();
            jdbcUrlBuilder.append(this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)));
            StringBuilder paramsBuilder = new StringBuilder();
            String paramUrl = this.jdbcUrl.substring(this.jdbcUrl.indexOf(63) + 1, this.jdbcUrl.length());
            for (String urlParam : urlParams = paramUrl.split("&")) {
                if (!urlParam.contains("currentSchema")) continue;
                paramsBuilder.append(urlParam);
                break;
            }
            if (paramsBuilder.length() > 0) {
                jdbcUrlBuilder.append("?");
                jdbcUrlBuilder.append((CharSequence)paramsBuilder);
            }
            return jdbcUrlBuilder.toString();
        }
        return this.jdbcUrl;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

