/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.kingbase;

import io.seata.common.loader.LoadLevel;
import io.seata.core.compressor.CompressorType;
import io.seata.rm.datasource.undo.AbstractUndoLogManager;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="kingbase")
public class KingBaseUndoLogManager
extends AbstractUndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KingBaseUndoLogManager.class);
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + " (id,branch_id, xid, context, rollback_info, log_status, log_created, log_modified)VALUES (nextval('UNDO_LOG_SEQ'), ?, ?, ?, ?, ?, now(), now())";
    private static final String DELETE_UNDO_LOG_BY_CREATE_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE log_created <= ? and ROWNUM <= ?";

    @Override
    public int deleteUndoLogByLogCreated(Date logCreated, int limitRows, Connection conn) throws SQLException {
        try {
            int var7;
            try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_BY_CREATE_SQL);){
                deletePST.setDate(1, new java.sql.Date(logCreated.getTime()));
                deletePST.setInt(2, limitRows);
                int deleteRows = deletePST.executeUpdate();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("batch delete undo log size {}", (Object)deleteRows);
                }
                var7 = deleteRows;
            }
            return var7;
        }
        catch (Exception var19) {
            Exception e = var19;
            if (!(var19 instanceof SQLException)) {
                e = new SQLException(var19);
            }
            throw (SQLException)e;
        }
    }

    @Override
    protected void insertUndoLogWithNormal(String xid, long branchId, String rollbackCtx, byte[] undoLogContent, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, rollbackCtx, undoLogContent, AbstractUndoLogManager.State.Normal, conn);
    }

    @Override
    protected void insertUndoLogWithGlobalFinished(String xid, long branchId, UndoLogParser parser, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, this.buildContext(parser.getName(), CompressorType.NONE), parser.getDefaultContent(), AbstractUndoLogManager.State.GlobalFinished, conn);
    }

    private void insertUndoLog(String xid, long branchID, String rollbackCtx, byte[] undoLogContent, AbstractUndoLogManager.State state, Connection conn) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(INSERT_UNDO_LOG_SQL);){
            pst.setLong(1, branchID);
            pst.setString(2, xid);
            pst.setString(3, rollbackCtx);
            pst.setBytes(4, undoLogContent);
            pst.setInt(5, state.getValue());
            pst.executeUpdate();
        }
        catch (Exception var21) {
            Exception e = var21;
            if (!(var21 instanceof SQLException)) {
                e = new SQLException(var21);
            }
            throw (SQLException)e;
        }
    }
}

