/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.discovery.shared.Application;
import io.seata.common.exception.EurekaRegistryException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import io.seata.discovery.registry.eureka.CustomEurekaInstanceConfig;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRegistryServiceImpl
implements RegistryService<EurekaEventListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaRegistryServiceImpl.class);
    private static final String DEFAULT_APPLICATION = "default";
    private static final String PRO_SERVICE_URL_KEY = "serviceUrl";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "eureka";
    private static final String CLUSTER = "application";
    private static final String REGISTRY_WEIGHT = "weight";
    private static final String EUREKA_CONFIG_SERVER_URL_KEY = "eureka.serviceUrl.default";
    private static final String EUREKA_CONFIG_REFRESH_KEY = "eureka.client.refresh.interval";
    private static final String EUREKA_CONFIG_SHOULD_REGISTER = "eureka.registration.enabled";
    private static final String EUREKA_CONFIG_METADATA_WEIGHT = "eureka.metadata.weight";
    private static final int EUREKA_REFRESH_INTERVAL = 5;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final String DEFAULT_WEIGHT = "1";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static ConcurrentMap<String, Set<InetSocketAddress>> clusterAddressMap;
    private static volatile boolean subscribeListener;
    private static volatile ApplicationInfoManager applicationInfoManager;
    private static volatile CustomEurekaInstanceConfig instanceConfig;
    private static volatile EurekaRegistryServiceImpl instance;
    private static volatile EurekaClient eurekaClient;

    private EurekaRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static EurekaRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<EurekaRegistryServiceImpl> clazz = EurekaRegistryServiceImpl.class;
        synchronized (EurekaRegistryServiceImpl.class) {
            if (instance != null) return instance;
            clusterAddressMap = new ConcurrentHashMap<String, Set<InetSocketAddress>>(8);
            instanceConfig = new CustomEurekaInstanceConfig();
            instance = new EurekaRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        instanceConfig.setIpAddress(address.getAddress().getHostAddress());
        instanceConfig.setPort(address.getPort());
        instanceConfig.setApplicationName(this.getApplicationName());
        instanceConfig.setInstanceId(this.getInstanceId());
        this.getEurekaClient(true);
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
    }

    public void unregister(InetSocketAddress address) throws Exception {
        if (eurekaClient == null) {
            return;
        }
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
    }

    public void subscribe(String cluster, EurekaEventListener listener) throws Exception {
        subscribeListener = true;
        this.getEurekaClient(false).registerEventListener(listener);
    }

    public void unsubscribe(String cluster, EurekaEventListener listener) throws Exception {
        subscribeListener = false;
        this.getEurekaClient(false).unregisterEventListener(listener);
    }

    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            return null;
        }
        if (!subscribeListener) {
            this.refreshCluster();
            this.subscribe((String)null, event -> {
                try {
                    this.refreshCluster();
                }
                catch (Exception e) {
                    LOGGER.error("Eureka event listener refreshCluster error:{}", (Object)e.getMessage(), (Object)e);
                }
            });
        }
        return new ArrayList<InetSocketAddress>(clusterAddressMap.getOrDefault(clusterName.toUpperCase(), Collections.emptySet()));
    }

    public void close() throws Exception {
        if (eurekaClient != null) {
            eurekaClient.shutdown();
        }
        this.clean();
    }

    private void refreshCluster() {
        List applications = this.getEurekaClient(false).getApplications().getRegisteredApplications();
        if (CollectionUtils.isEmpty((Collection)applications)) {
            clusterAddressMap.clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("refreshCluster success, cluster empty!");
            }
            return;
        }
        ConcurrentHashMap<String, Set<InetSocketAddress>> collect = new ConcurrentHashMap<String, Set<InetSocketAddress>>(8);
        for (Application application : applications) {
            List instances = application.getInstances();
            if (!CollectionUtils.isNotEmpty((Collection)instances)) continue;
            Set addressSet = instances.stream().map(instance -> new InetSocketAddress(instance.getIPAddr(), instance.getPort())).collect(Collectors.toSet());
            collect.put(application.getName(), addressSet);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("refreshCluster success, cluster: " + collect);
        }
        clusterAddressMap = collect;
    }

    private Properties getEurekaProperties(boolean needRegister) {
        Properties eurekaProperties = new Properties();
        eurekaProperties.setProperty(EUREKA_CONFIG_REFRESH_KEY, String.valueOf(5));
        String url = FILE_CONFIG.getConfig(this.getEurekaServerUrlFileKey());
        if (StringUtils.isBlank((String)url)) {
            throw new EurekaRegistryException("eureka server url can not be null!");
        }
        eurekaProperties.setProperty(EUREKA_CONFIG_SERVER_URL_KEY, url);
        String weight = FILE_CONFIG.getConfig(this.getEurekaInstanceWeightFileKey());
        if (StringUtils.isNotBlank((String)weight)) {
            eurekaProperties.setProperty(EUREKA_CONFIG_METADATA_WEIGHT, weight);
        } else {
            eurekaProperties.setProperty(EUREKA_CONFIG_METADATA_WEIGHT, DEFAULT_WEIGHT);
        }
        if (!needRegister) {
            eurekaProperties.setProperty(EUREKA_CONFIG_SHOULD_REGISTER, "false");
        }
        return eurekaProperties;
    }

    private String getApplicationName() {
        String application = FILE_CONFIG.getConfig(this.getEurekaApplicationFileKey());
        if (application == null) {
            application = DEFAULT_APPLICATION;
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EurekaClient getEurekaClient(boolean needRegister) throws EurekaRegistryException {
        if (eurekaClient != null) return eurekaClient;
        Class<EurekaRegistryServiceImpl> clazz = EurekaRegistryServiceImpl.class;
        synchronized (EurekaRegistryServiceImpl.class) {
            try {
                if (eurekaClient != null) return eurekaClient;
                if (!needRegister) {
                    instanceConfig = new CustomEurekaInstanceConfig();
                }
                ConfigurationManager.loadProperties((Properties)this.getEurekaProperties(needRegister));
                InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider((EurekaInstanceConfig)instanceConfig).get();
                applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)instanceConfig, instanceInfo);
                eurekaClient = new DiscoveryClient(applicationInfoManager, (EurekaClientConfig)new DefaultEurekaClientConfig());
            }
            catch (Exception e) {
                this.clean();
                throw new EurekaRegistryException("register eureka is error!", (Throwable)e);
            }
            return eurekaClient;
        }
    }

    private void clean() {
        eurekaClient = null;
        applicationInfoManager = null;
        instanceConfig = null;
    }

    private String getInstanceId() {
        return String.format("%s:%s:%d", instanceConfig.getIpAddress(), instanceConfig.getAppname(), instanceConfig.getNonSecurePort());
    }

    private String getEurekaServerUrlFileKey() {
        return String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, PRO_SERVICE_URL_KEY);
    }

    private String getEurekaApplicationFileKey() {
        return String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, CLUSTER);
    }

    private String getEurekaInstanceWeightFileKey() {
        return String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, REGISTRY_WEIGHT);
    }

    static {
        subscribeListener = false;
    }
}

