/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.event;

import com.google.common.eventbus.AsyncEventBus;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.core.event.Event;
import io.seata.core.event.EventBus;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaEventBus
implements EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuavaEventBus.class);
    private final com.google.common.eventbus.EventBus eventBus;

    public GuavaEventBus(String identifier) {
        this(identifier, false);
    }

    public GuavaEventBus(String identifier, boolean async) {
        if (!async) {
            this.eventBus = new com.google.common.eventbus.EventBus(identifier);
        } else {
            ThreadPoolExecutor eventExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(2048), (ThreadFactory)new NamedThreadFactory(identifier, 1), (r, executor) -> LOGGER.warn("eventBus executor queue is full, size:{}", (Object)executor.getQueue().size()));
            this.eventBus = new AsyncEventBus(identifier, (Executor)eventExecutor);
        }
    }

    @Override
    public void register(Object subscriber) {
        this.eventBus.register(subscriber);
    }

    @Override
    public void unregister(Object subscriber) {
        this.eventBus.unregister(subscriber);
    }

    @Override
    public void post(Event event) {
        this.eventBus.post((Object)event);
    }
}

