/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.seata.core.rpc.netty.NettyBaseConfig;

public class NettyServerConfig
extends NettyBaseConfig {
    private int serverSelectorThreads = WORKER_THREAD_SIZE;
    private int serverSocketSendBufSize = 153600;
    private int serverSocketResvBufSize = 153600;
    private int serverWorkerThreads = WORKER_THREAD_SIZE;
    private int soBackLogSize = 1024;
    private int writeBufferHighWaterMark = 0x4000000;
    private int writeBufferLowWaterMark = 0x100000;
    private static final int DEFAULT_LISTEN_PORT = 8091;
    private static final int RPC_REQUEST_TIMEOUT = 30000;
    private boolean enableServerPooledByteBufAllocator = true;
    private int serverChannelMaxIdleTimeSeconds = 30;
    private static final String DEFAULT_BOSS_THREAD_PREFIX = "NettyBoss";
    private static final String EPOLL_WORKER_THREAD_PREFIX = "NettyServerEPollWorker";
    private static final String NIO_WORKER_THREAD_PREFIX = "NettyServerNIOWorker";
    private static final String DEFAULT_EXECUTOR_THREAD_PREFIX = "NettyServerBizHandler";
    private static final int DEFAULT_BOSS_THREAD_SIZE = 1;
    private static final int DEFAULT_SHUTDOWN_TIMEOUT_SEC = 3;
    public final Class<? extends ServerChannel> SERVER_CHANNEL_CLAZZ = NettyBaseConfig.SERVER_CHANNEL_CLAZZ;
    public static final PooledByteBufAllocator DIRECT_BYTE_BUF_ALLOCATOR = new PooledByteBufAllocator(true, WORKER_THREAD_SIZE, WORKER_THREAD_SIZE, 131072, 10, 512, 256, 64, true, 0);

    public int getServerSelectorThreads() {
        return this.serverSelectorThreads;
    }

    public void setServerSelectorThreads(int serverSelectorThreads) {
        this.serverSelectorThreads = serverSelectorThreads;
    }

    public static boolean enableEpoll() {
        return NettyBaseConfig.SERVER_CHANNEL_CLAZZ.equals(EpollServerSocketChannel.class) && Epoll.isAvailable();
    }

    public int getServerSocketSendBufSize() {
        return this.serverSocketSendBufSize;
    }

    public void setServerSocketSendBufSize(int serverSocketSendBufSize) {
        this.serverSocketSendBufSize = serverSocketSendBufSize;
    }

    public int getServerSocketResvBufSize() {
        return this.serverSocketResvBufSize;
    }

    public void setServerSocketResvBufSize(int serverSocketResvBufSize) {
        this.serverSocketResvBufSize = serverSocketResvBufSize;
    }

    public int getServerWorkerThreads() {
        return this.serverWorkerThreads;
    }

    public void setServerWorkerThreads(int serverWorkerThreads) {
        this.serverWorkerThreads = serverWorkerThreads;
    }

    public int getSoBackLogSize() {
        return this.soBackLogSize;
    }

    public void setSoBackLogSize(int soBackLogSize) {
        this.soBackLogSize = soBackLogSize;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public int getDefaultListenPort() {
        return 8091;
    }

    public int getChannelMaxReadIdleSeconds() {
        return MAX_READ_IDLE_SECONDS;
    }

    public boolean isEnableServerPooledByteBufAllocator() {
        return this.enableServerPooledByteBufAllocator;
    }

    public void setEnableServerPooledByteBufAllocator(boolean enableServerPooledByteBufAllocator) {
        this.enableServerPooledByteBufAllocator = enableServerPooledByteBufAllocator;
    }

    public int getServerChannelMaxIdleTimeSeconds() {
        return this.serverChannelMaxIdleTimeSeconds;
    }

    public static int getRpcRequestTimeout() {
        return 30000;
    }

    public String getBossThreadPrefix() {
        return CONFIG.getConfig("transport.thread-factory.boss-thread-prefix", DEFAULT_BOSS_THREAD_PREFIX);
    }

    public String getWorkerThreadPrefix() {
        return CONFIG.getConfig("transport.thread-factory.worker-thread-prefix", NettyServerConfig.enableEpoll() ? EPOLL_WORKER_THREAD_PREFIX : NIO_WORKER_THREAD_PREFIX);
    }

    public String getExecutorThreadPrefix() {
        return CONFIG.getConfig("transport.thread-factory.server-executor-thread-prefix", DEFAULT_EXECUTOR_THREAD_PREFIX);
    }

    public int getBossThreadSize() {
        return CONFIG.getInt("transport.thread-factory.boss-thread-size", 1);
    }

    public int getServerShutdownWaitTime() {
        return CONFIG.getInt("transport.shutdown.wait", 3);
    }
}

