/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.codec;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.core.codec.Codec;
import io.seata.core.codec.CodecType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodecFactory {
    protected static final Map<CodecType, Codec> CODEC_MAP = new ConcurrentHashMap<CodecType, Codec>();

    public static synchronized Codec getCodec(byte codec) {
        CodecType codecType = CodecType.getByCode(codec);
        if (CODEC_MAP.get((Object)codecType) != null) {
            return CODEC_MAP.get((Object)codecType);
        }
        Codec codecImpl = (Codec)EnhancedServiceLoader.load(Codec.class, (String)codecType.name());
        CODEC_MAP.put(codecType, codecImpl);
        return codecImpl;
    }

    public static <T> byte[] encode(byte codec, T t) {
        return CodecFactory.getCodec(codec).encode(t);
    }

    public static <T> T decode(byte codec, byte[] bytes) {
        return CodecFactory.getCodec(codec).decode(bytes);
    }
}

