/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.util.Pool;
import de.javakaffee.kryoserializers.BitSetSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.RegexSerializer;
import de.javakaffee.kryoserializers.URISerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import io.seata.core.serializer.SerializerClassRegistry;
import io.seata.serializer.kryo.KryoInnerSerializer;
import java.lang.reflect.InvocationHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.BitSet;
import java.util.UUID;
import java.util.regex.Pattern;

public class KryoSerializerFactory {
    private static final KryoSerializerFactory FACTORY = new KryoSerializerFactory();
    private Pool<Kryo> pool = new Pool<Kryo>(true, true){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setReferences(true);
            kryo.setRegistrationRequired(false);
            kryo.register(Arrays.asList("").getClass());
            kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
            kryo.register(BigDecimal.class, (Serializer)new DefaultSerializers.BigDecimalSerializer());
            kryo.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
            kryo.register(Pattern.class, (Serializer)new RegexSerializer());
            kryo.register(BitSet.class, (Serializer)new BitSetSerializer());
            kryo.register(URI.class, (Serializer)new URISerializer());
            kryo.register(UUID.class, (Serializer)new UUIDSerializer());
            SerializerClassRegistry.getRegisteredClasses().keySet().forEach(arg_0 -> ((Kryo)kryo).register(arg_0));
            return kryo;
        }
    };

    private KryoSerializerFactory() {
    }

    public static KryoSerializerFactory getInstance() {
        return FACTORY;
    }

    public KryoInnerSerializer get() {
        return new KryoInnerSerializer((Kryo)this.pool.obtain());
    }

    public void returnKryo(KryoInnerSerializer kryoSerializer) {
        if (kryoSerializer == null) {
            throw new IllegalArgumentException("kryoSerializer is null");
        }
        this.pool.free((Object)kryoSerializer.getKryo());
    }
}

