/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.TCCResource;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.ActionContextUtil;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.RemotingParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultRemotingParser {
    protected static List<RemotingParser> allRemotingParsers = new ArrayList<RemotingParser>();
    protected static Map<String, RemotingDesc> remotingServiceMap = new ConcurrentHashMap<String, RemotingDesc>();

    public static DefaultRemotingParser get() {
        return SingletonHolder.INSTANCE;
    }

    protected DefaultRemotingParser() {
        this.initRemotingParser();
    }

    protected void initRemotingParser() {
        List<RemotingParser> remotingParsers = EnhancedServiceLoader.loadAll(RemotingParser.class);
        if (CollectionUtils.isNotEmpty(remotingParsers)) {
            allRemotingParsers.addAll(remotingParsers);
        }
    }

    public RemotingParser isRemoting(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isRemoting(bean, beanName)) continue;
            return remotingParser;
        }
        return null;
    }

    public boolean isReference(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isReference(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public boolean isService(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isService(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public RemotingDesc getServiceDesc(Object bean, String beanName) {
        ArrayList<RemotingDesc> ret = new ArrayList<RemotingDesc>();
        for (RemotingParser remotingParser : allRemotingParsers) {
            RemotingDesc s = remotingParser.getServiceDesc(bean, beanName);
            if (s == null) continue;
            ret.add(s);
        }
        if (ret.size() == 1) {
            return (RemotingDesc)ret.get(0);
        }
        if (ret.size() > 1) {
            throw new FrameworkException(String.format("More than one RemotingParser for bean: %s", beanName));
        }
        return null;
    }

    public RemotingDesc parserRemotingServiceInfo(Object bean, String beanName, RemotingParser remotingParser) {
        RemotingDesc remotingBeanDesc = remotingParser.getServiceDesc(bean, beanName);
        if (remotingBeanDesc == null) {
            return null;
        }
        remotingServiceMap.put(beanName, remotingBeanDesc);
        Class<?> serviceClass = remotingBeanDesc.getServiceClass();
        Method[] methods = serviceClass.getMethods();
        if (remotingParser.isService(bean, beanName)) {
            try {
                Object targetBean = remotingBeanDesc.getTargetBean();
                for (Method m : methods) {
                    TwoPhaseBusinessAction twoPhaseBusinessAction = m.getAnnotation(TwoPhaseBusinessAction.class);
                    if (twoPhaseBusinessAction == null) continue;
                    TCCResource tccResource = new TCCResource();
                    tccResource.setActionName(twoPhaseBusinessAction.name());
                    tccResource.setTargetBean(targetBean);
                    tccResource.setPrepareMethod(m);
                    tccResource.setCommitMethodName(twoPhaseBusinessAction.commitMethod());
                    tccResource.setCommitMethod(serviceClass.getMethod(twoPhaseBusinessAction.commitMethod(), twoPhaseBusinessAction.commitArgsClasses()));
                    tccResource.setRollbackMethodName(twoPhaseBusinessAction.rollbackMethod());
                    tccResource.setRollbackMethod(serviceClass.getMethod(twoPhaseBusinessAction.rollbackMethod(), twoPhaseBusinessAction.rollbackArgsClasses()));
                    tccResource.setCommitArgsClasses(twoPhaseBusinessAction.commitArgsClasses());
                    tccResource.setRollbackArgsClasses(twoPhaseBusinessAction.rollbackArgsClasses());
                    tccResource.setPhaseTwoCommitKeys(this.getTwoPhaseArgs(tccResource.getCommitMethod(), twoPhaseBusinessAction.commitArgsClasses()));
                    tccResource.setPhaseTwoRollbackKeys(this.getTwoPhaseArgs(tccResource.getRollbackMethod(), twoPhaseBusinessAction.rollbackArgsClasses()));
                    DefaultResourceManager.get().registerResource(tccResource);
                }
            }
            catch (Throwable t) {
                throw new FrameworkException(t, "parser remoting service error");
            }
        }
        if (remotingParser.isReference(bean, beanName)) {
            remotingBeanDesc.setReference(true);
        }
        return remotingBeanDesc;
    }

    protected String[] getTwoPhaseArgs(Method method, Class<?>[] argsClasses) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] keys = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                String key;
                if (!(parameterAnnotations[i][j] instanceof BusinessActionContextParameter)) continue;
                BusinessActionContextParameter param = (BusinessActionContextParameter)parameterAnnotations[i][j];
                keys[i] = key = ActionContextUtil.getParamNameFromAnnotation(param);
                break;
            }
            if (keys[i] != null || argsClasses[i].equals(BusinessActionContext.class)) continue;
            throw new IllegalArgumentException("non-BusinessActionContext parameter should use annotation BusinessActionContextParameter");
        }
        return keys;
    }

    public RemotingDesc getRemotingBeanDesc(String beanName) {
        return remotingServiceMap.get(beanName);
    }

    private static class SingletonHolder {
        private static final DefaultRemotingParser INSTANCE = new DefaultRemotingParser();

        private SingletonHolder() {
        }
    }
}

