/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableMetaCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableMetaCache
implements TableMetaCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTableMetaCache.class);
    private static final long CACHE_SIZE = 100000L;
    private static final long EXPIRE_TIME = 900000L;
    private static final Cache<String, TableMeta> TABLE_META_CACHE;

    @Override
    public TableMeta getTableMeta(Connection connection, String tableName, String resourceId) {
        if (StringUtils.isNullOrEmpty(tableName)) {
            throw new IllegalArgumentException("TableMeta cannot be fetched without tableName");
        }
        String key = this.getCacheKey(connection, tableName, resourceId);
        TableMeta tmeta = (TableMeta)TABLE_META_CACHE.get((Object)key, mappingFunction -> {
            try {
                return this.fetchSchema(connection, tableName);
            }
            catch (SQLException e) {
                LOGGER.error("get table meta of the table `{}` error: {}", new Object[]{tableName, e.getMessage(), e});
                return null;
            }
        });
        if (tmeta == null) {
            throw new ShouldNeverHappenException(String.format("[xid:%s]get table meta failed, please check whether the table `%s` exists.", RootContext.getXID(), tableName));
        }
        return tmeta;
    }

    @Override
    public void refresh(Connection connection, String resourceId) {
        ConcurrentMap tableMetaMap = TABLE_META_CACHE.asMap();
        for (Map.Entry entry : tableMetaMap.entrySet()) {
            String key = this.getCacheKey(connection, ((TableMeta)entry.getValue()).getTableName(), resourceId);
            if (!((String)entry.getKey()).equals(key)) continue;
            try {
                TableMeta tableMeta = this.fetchSchema(connection, ((TableMeta)entry.getValue()).getTableName());
                if (tableMeta.equals(entry.getValue())) continue;
                TABLE_META_CACHE.put(entry.getKey(), (Object)tableMeta);
                LOGGER.info("table meta change was found, update table meta cache automatically.");
            }
            catch (SQLException e) {
                LOGGER.error("get table meta error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected abstract String getCacheKey(Connection var1, String var2, String var3);

    protected abstract TableMeta fetchSchema(Connection var1, String var2) throws SQLException;

    static {
        try {
            TABLE_META_CACHE = Caffeine.newBuilder().maximumSize(100000L).expireAfterWrite(900000L, TimeUnit.MILLISECONDS).softValues().build();
        }
        catch (Throwable t) {
            LOGGER.error("Build the `TABLE_META_CACHE` failed:", t);
            throw t;
        }
    }
}

