/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.loadbalance;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.discovery.loadbalance.LoadBalance;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="XID")
public class XIDLoadBalance
implements LoadBalance {
    private static final Logger LOGGER = LoggerFactory.getLogger(XIDLoadBalance.class);
    private static final LoadBalance RANDOM_LOAD_BALANCE = EnhancedServiceLoader.load(LoadBalance.class, "RandomLoadBalance");
    private static final String SPLIT = ":";

    @Override
    public <T> T select(List<T> invokers, String xid) throws Exception {
        if (StringUtils.isNotBlank(xid) && xid.contains(SPLIT)) {
            String serverAddress = xid.substring(0, xid.lastIndexOf(SPLIT));
            int index = serverAddress.lastIndexOf(SPLIT);
            int port = Integer.parseInt(serverAddress.substring(index + 1));
            String ip = serverAddress.substring(0, index);
            InetSocketAddress xidInetSocketAddress = new InetSocketAddress(ip, port);
            for (T invoker : invokers) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)invoker;
                if (!Objects.equals(xidInetSocketAddress, inetSocketAddress)) continue;
                return (T)inetSocketAddress;
            }
            LOGGER.error("not found seata-server channel,xid: {}, try use random load balance", (Object)xid);
        }
        return RANDOM_LOAD_BALANCE.select(invokers, xid);
    }
}

