/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid.dm;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import io.seata.common.util.CollectionUtils;
import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLParsingException;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.druid.dm.BaseDmRecognizer;
import io.seata.sqlparser.struct.NotPlaceholderExpr;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.SqlMethodExpr;
import io.seata.sqlparser.struct.SqlSequenceExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DmInsertRecognizer
extends BaseDmRecognizer
implements SQLInsertRecognizer {
    private final SQLInsertStatement ast;

    public DmInsertRecognizer(String originalSQL, SQLStatement ast) {
        super(originalSQL);
        this.ast = (SQLInsertStatement)ast;
    }

    @Override
    public SQLType getSQLType() {
        return SQLType.INSERT;
    }

    @Override
    public String getTableAlias() {
        return this.ast.getTableSource().getAlias();
    }

    @Override
    public String getTableName() {
        StringBuilder sb = new StringBuilder();
        OracleOutputVisitor visitor = new OracleOutputVisitor(sb){

            public boolean visit(SQLExprTableSource x) {
                this.printTableSourceExpr(x.getExpr());
                return false;
            }
        };
        visitor.visit(this.ast.getTableSource());
        return sb.toString();
    }

    @Override
    public boolean insertColumnsIsEmpty() {
        return CollectionUtils.isEmpty(this.ast.getColumns());
    }

    @Override
    public List<String> getInsertColumns() {
        List columnSQLExprs = this.ast.getColumns();
        if (columnSQLExprs.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(columnSQLExprs.size());
        for (SQLExpr expr : columnSQLExprs) {
            if (expr instanceof SQLIdentifierExpr) {
                list.add(((SQLIdentifierExpr)expr).getName());
                continue;
            }
            throw new SQLParsingException("Unknown SQLExpr: " + expr.getClass() + " " + expr);
        }
        return list;
    }

    @Override
    public List<List<Object>> getInsertRows(Collection<Integer> primaryKeyIndex) {
        List valuesClauses = this.ast.getValuesList();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(valuesClauses.size());
        for (SQLInsertStatement.ValuesClause valuesClause : valuesClauses) {
            List exprs = valuesClause.getValues();
            ArrayList<Object> row = new ArrayList<Object>(exprs.size());
            rows.add(row);
            int len = exprs.size();
            for (int i = 0; i < len; ++i) {
                SQLExpr expr = (SQLExpr)exprs.get(i);
                if (expr instanceof SQLNullExpr) {
                    row.add(Null.get());
                    continue;
                }
                if (expr instanceof SQLValuableExpr) {
                    row.add(((SQLValuableExpr)expr).getValue());
                    continue;
                }
                if (expr instanceof SQLVariantRefExpr) {
                    row.add(((SQLVariantRefExpr)expr).getName());
                    continue;
                }
                if (expr instanceof SQLMethodInvokeExpr) {
                    row.add(SqlMethodExpr.get());
                    continue;
                }
                if (expr instanceof SQLSequenceExpr) {
                    SQLSequenceExpr sequenceExpr = (SQLSequenceExpr)expr;
                    String sequence = sequenceExpr.getSequence().getSimpleName();
                    String function = sequenceExpr.getFunction().name;
                    row.add(new SqlSequenceExpr(sequence, function));
                    continue;
                }
                if (primaryKeyIndex.contains(i)) {
                    throw new SQLParsingException("Unknown SQLExpr: " + expr.getClass() + " " + expr);
                }
                row.add(NotPlaceholderExpr.get());
            }
        }
        return rows;
    }
}

