/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.protobuf;

import com.google.protobuf.MessageLite;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProtobufHelper {
    ConcurrentMap<Class, Method> parseFromMethodMap = new ConcurrentHashMap<Class, Method>();
    ConcurrentMap<Class, Method> toByteArrayMethodMap = new ConcurrentHashMap<Class, Method>();
    private ConcurrentMap<String, Class> requestClassCache = new ConcurrentHashMap<String, Class>();

    public Class getPbClass(String clazzName) {
        return CollectionUtils.computeIfAbsent(this.requestClassCache, clazzName, key -> {
            Class<?> clazz;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new ShouldNeverHappenException("get class occurs exception", e);
            }
            if (clazz == Void.TYPE || !this.isProtoBufMessageClass(clazz)) {
                throw new ShouldNeverHappenException("class based protobuf: " + clazz.getName() + ", only support return protobuf message!");
            }
            return clazz;
        });
    }

    boolean isProtoBufMessageClass(Class clazz) {
        return clazz != null && MessageLite.class.isAssignableFrom(clazz);
    }
}

