/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.store.db;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.StoreException;
import io.seata.common.util.CollectionUtils;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.GlobalStatus;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.config.DbStateMachineConfig;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.impl.DefaultStateMachineConfig;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.sequence.SeqGenerator;
import io.seata.saga.engine.serializer.Serializer;
import io.seata.saga.engine.serializer.impl.ExceptionSerializer;
import io.seata.saga.engine.serializer.impl.ParamsSerializer;
import io.seata.saga.engine.store.StateLogStore;
import io.seata.saga.engine.store.db.AbstractStore;
import io.seata.saga.engine.store.db.StateLogStoreSqls;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import io.seata.saga.statelang.domain.impl.StateInstanceImpl;
import io.seata.saga.statelang.domain.impl.StateMachineInstanceImpl;
import io.seata.saga.tm.SagaTransactionalTemplate;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.TransactionInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DbAndReportTcStateLogStore
extends AbstractStore
implements StateLogStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAndReportTcStateLogStore.class);
    private static final StateMachineInstanceToStatementForInsert STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_INSERT = new StateMachineInstanceToStatementForInsert();
    private static final StateMachineInstanceToStatementForUpdate STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_UPDATE = new StateMachineInstanceToStatementForUpdate();
    private static final ResultSetToStateMachineInstance RESULT_SET_TO_STATE_MACHINE_INSTANCE = new ResultSetToStateMachineInstance();
    private static final StateInstanceToStatementForInsert STATE_INSTANCE_TO_STATEMENT_FOR_INSERT = new StateInstanceToStatementForInsert();
    private static final StateInstanceToStatementForUpdate STATE_INSTANCE_TO_STATEMENT_FOR_UPDATE = new StateInstanceToStatementForUpdate();
    private static final ResultSetToStateInstance RESULT_SET_TO_STATE_INSTANCE = new ResultSetToStateInstance();
    private SagaTransactionalTemplate sagaTransactionalTemplate;
    private Serializer<Object, String> paramsSerializer = new ParamsSerializer();
    private Serializer<Exception, byte[]> exceptionSerializer = new ExceptionSerializer();
    private StateLogStoreSqls stateLogStoreSqls;
    private String defaultTenantId;
    private SeqGenerator seqGenerator;

    @Override
    public void recordStateMachineStarted(StateMachineInstance machineInstance, ProcessContext context) {
        if (machineInstance != null) {
            String parentId = machineInstance.getParentId();
            if (StringUtils.isEmpty((Object)parentId)) {
                this.beginTransaction(machineInstance, context);
            }
            try {
                if (StringUtils.isEmpty((Object)machineInstance.getId()) && this.seqGenerator != null) {
                    machineInstance.setId(this.seqGenerator.generate("STATE_MACHINE_INST"));
                }
                RootContext.bindBranchType(BranchType.SAGA);
                machineInstance.setSerializedStartParams(this.paramsSerializer.serialize(machineInstance.getStartParams()));
                int effect = this.executeUpdate(this.stateLogStoreSqls.getRecordStateMachineStartedSql(this.dbType), STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_INSERT, machineInstance);
                if (effect < 1) {
                    throw new StoreException("StateMachineInstance record start error, Xid: " + machineInstance.getId(), FrameworkErrorCode.OperationDenied);
                }
            }
            catch (StoreException e) {
                LOGGER.error("Record statemachine start error: {}, StateMachine: {}, XID: {}, Reason: {}", new Object[]{e.getErrcode(), machineInstance.getStateMachine().getName(), machineInstance.getId(), e.getMessage(), e});
                RootContext.unbind();
                RootContext.unbindBranchType();
                if (this.sagaTransactionalTemplate != null) {
                    this.sagaTransactionalTemplate.cleanUp();
                }
                throw e;
            }
        }
    }

    protected void beginTransaction(StateMachineInstance machineInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            TransactionInfo transactionInfo = new TransactionInfo();
            transactionInfo.setTimeOut(stateMachineConfig.getTransOperationTimeout());
            transactionInfo.setName("$Saga_" + machineInstance.getStateMachine().getName());
            try {
                GlobalTransaction globalTransaction = this.sagaTransactionalTemplate.beginTransaction(transactionInfo);
                machineInstance.setId(globalTransaction.getXid());
                context.setVariable("_global_transaction_", globalTransaction);
                Map<String, Object> machineContext = machineInstance.getContext();
                if (machineContext != null) {
                    machineContext.put("_global_transaction_", globalTransaction);
                }
            }
            catch (TransactionalExecutor.ExecutionException e) {
                String xid = null;
                if (e.getTransaction() != null) {
                    xid = e.getTransaction().getXid();
                }
                throw new EngineExecutionException(e, (Object)((Object)e.getCode()) + ", TransName:" + transactionInfo.getName() + ", XID: " + xid + ", Reason: " + e.getMessage(), FrameworkErrorCode.TransactionManagerError);
            }
            finally {
                if (Boolean.TRUE.equals(context.getVariable("_is_async_execution_"))) {
                    RootContext.unbind();
                    RootContext.unbindBranchType();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordStateMachineFinished(StateMachineInstance machineInstance, ProcessContext context) {
        if (machineInstance != null) {
            try {
                Map<String, Object> endParams = machineInstance.getEndParams();
                if (endParams != null) {
                    endParams.remove("_global_transaction_");
                }
                if (ExecutionStatus.SU.equals((Object)machineInstance.getStatus()) && machineInstance.getException() != null) {
                    machineInstance.setException(null);
                }
                machineInstance.setSerializedEndParams(this.paramsSerializer.serialize(machineInstance.getEndParams()));
                machineInstance.setSerializedException(this.exceptionSerializer.serialize(machineInstance.getException()));
                int effect = this.executeUpdate(this.stateLogStoreSqls.getRecordStateMachineFinishedSql(this.dbType), STATE_MACHINE_INSTANCE_TO_STATEMENT_FOR_UPDATE, machineInstance);
                if (effect < 1) {
                    LOGGER.warn("StateMachineInstance[{}] is recovery by server, skip recordStateMachineFinished.", (Object)machineInstance.getId());
                } else {
                    StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
                    if (EngineUtils.isTimeout(machineInstance.getGmtUpdated(), stateMachineConfig.getTransOperationTimeout())) {
                        LOGGER.warn("StateMachineInstance[{}] is execution timeout, skip report transaction finished to server.", (Object)machineInstance.getId());
                    } else if (StringUtils.isEmpty((Object)machineInstance.getParentId())) {
                        this.reportTransactionFinished(machineInstance, context);
                    }
                }
            }
            finally {
                RootContext.unbind();
                RootContext.unbindBranchType();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportTransactionFinished(StateMachineInstance machineInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            try {
                GlobalTransaction globalTransaction = this.getGlobalTransaction(machineInstance, context);
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                GlobalStatus globalStatus = ExecutionStatus.SU.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null ? GlobalStatus.Committed : (ExecutionStatus.SU.equals((Object)machineInstance.getCompensationStatus()) ? GlobalStatus.Rollbacked : (ExecutionStatus.FA.equals((Object)machineInstance.getCompensationStatus()) || ExecutionStatus.UN.equals((Object)machineInstance.getCompensationStatus()) ? GlobalStatus.RollbackRetrying : (ExecutionStatus.FA.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null ? GlobalStatus.Finished : (ExecutionStatus.UN.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null ? GlobalStatus.CommitRetrying : GlobalStatus.UnKnown))));
                this.sagaTransactionalTemplate.reportTransaction(globalTransaction, globalStatus);
            }
            catch (TransactionalExecutor.ExecutionException e) {
                LOGGER.error("Report transaction finish to server error: {}, StateMachine: {}, XID: {}, Reason: {}", new Object[]{e.getCode(), machineInstance.getStateMachine().getName(), machineInstance.getId(), e.getMessage(), e});
            }
            catch (TransactionException e) {
                LOGGER.error("Report transaction finish to server error: {}, StateMachine: {}, XID: {}, Reason: {}", new Object[]{e.getCode(), machineInstance.getStateMachine().getName(), machineInstance.getId(), e.getMessage(), e});
            }
            finally {
                RootContext.unbind();
                RootContext.unbindBranchType();
                this.sagaTransactionalTemplate.triggerAfterCompletion();
                this.sagaTransactionalTemplate.cleanUp();
            }
        }
    }

    @Override
    public void recordStateMachineRestarted(StateMachineInstance machineInstance, ProcessContext context) {
        if (machineInstance != null) {
            Date gmtUpdated = new Date();
            int effect = this.executeUpdate(this.stateLogStoreSqls.getUpdateStateMachineRunningStatusSql(this.dbType), machineInstance.isRunning(), new Timestamp(gmtUpdated.getTime()), machineInstance.getId(), new Timestamp(machineInstance.getGmtUpdated().getTime()));
            if (effect < 1) {
                throw new EngineExecutionException("StateMachineInstance [id:" + machineInstance.getId() + "] is recovered by an other execution, restart denied", FrameworkErrorCode.OperationDenied);
            }
            machineInstance.setGmtUpdated(gmtUpdated);
        }
    }

    @Override
    public void recordStateStarted(StateInstance stateInstance, ProcessContext context) {
        if (stateInstance != null) {
            boolean isUpdateMode = this.isUpdateMode(stateInstance, context);
            if (StringUtils.hasLength((String)stateInstance.getStateIdRetriedFor())) {
                if (isUpdateMode) {
                    stateInstance.setId(stateInstance.getStateIdRetriedFor());
                } else {
                    stateInstance.setId(this.generateRetryStateInstanceId(stateInstance));
                }
            } else if (StringUtils.hasLength((String)stateInstance.getStateIdCompensatedFor())) {
                stateInstance.setId(this.generateCompensateStateInstanceId(stateInstance, isUpdateMode));
            } else {
                this.branchRegister(stateInstance, context);
            }
            if (StringUtils.isEmpty((Object)stateInstance.getId()) && this.seqGenerator != null) {
                stateInstance.setId(this.seqGenerator.generate("STATE_INST"));
            }
            stateInstance.setSerializedInputParams(this.paramsSerializer.serialize(stateInstance.getInputParams()));
            if (!isUpdateMode) {
                this.executeUpdate(this.stateLogStoreSqls.getRecordStateStartedSql(this.dbType), STATE_INSTANCE_TO_STATEMENT_FOR_INSERT, stateInstance);
            } else {
                this.executeUpdate(this.stateLogStoreSqls.getUpdateStateExecutionStatusSql(this.dbType), stateInstance.getStatus().name(), new Timestamp(System.currentTimeMillis()), stateInstance.getMachineInstanceId(), stateInstance.getId());
            }
        }
    }

    protected void branchRegister(StateInstance stateInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            if (stateMachineConfig instanceof DbStateMachineConfig && !((DbStateMachineConfig)stateMachineConfig).isSagaBranchRegisterEnable()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("sagaBranchRegisterEnable = false, skip register branch. state[" + stateInstance.getName() + "]");
                }
                return;
            }
            try {
                StateMachineInstance machineInstance = stateInstance.getStateMachineInstance();
                GlobalTransaction globalTransaction = this.getGlobalTransaction(machineInstance, context);
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                String resourceId = stateInstance.getStateMachineInstance().getStateMachine().getName() + "#" + stateInstance.getName();
                long branchId = this.sagaTransactionalTemplate.branchRegister(resourceId, null, globalTransaction.getXid(), null, null);
                stateInstance.setId(String.valueOf(branchId));
            }
            catch (TransactionException e) {
                throw new EngineExecutionException(e, "Branch transaction error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + stateInstance.getStateMachineInstance().getStateMachine().getName() + ", XID: " + stateInstance.getStateMachineInstance().getId() + ", State:" + stateInstance.getName() + ", stateId: " + stateInstance.getId() + ", Reason: " + e.getMessage(), FrameworkErrorCode.TransactionManagerError);
            }
            catch (TransactionalExecutor.ExecutionException e) {
                throw new EngineExecutionException(e, "Branch transaction error: " + (Object)((Object)e.getCode()) + ", StateMachine:" + stateInstance.getStateMachineInstance().getStateMachine().getName() + ", XID: " + stateInstance.getStateMachineInstance().getId() + ", State:" + stateInstance.getName() + ", stateId: " + stateInstance.getId() + ", Reason: " + e.getMessage(), FrameworkErrorCode.TransactionManagerError);
            }
        }
    }

    protected GlobalTransaction getGlobalTransaction(StateMachineInstance machineInstance, ProcessContext context) throws TransactionalExecutor.ExecutionException, TransactionException {
        String parentId;
        String xid;
        GlobalTransaction globalTransaction = (GlobalTransaction)context.getVariable("_global_transaction_");
        if (globalTransaction == null && (globalTransaction = this.sagaTransactionalTemplate.reloadTransaction(xid = StringUtils.isEmpty((Object)(parentId = machineInstance.getParentId())) ? machineInstance.getId() : parentId.substring(0, parentId.lastIndexOf(":")))) != null) {
            context.setVariable("_global_transaction_", globalTransaction);
        }
        return globalTransaction;
    }

    private String generateRetryStateInstanceId(StateInstance stateInstance) {
        String originalStateInstId = stateInstance.getStateIdRetriedFor();
        int maxIndex = 1;
        Map<String, StateInstance> stateInstanceMap = stateInstance.getStateMachineInstance().getStateMap();
        StateInstance originalStateInst = stateInstanceMap.get(stateInstance.getStateIdRetriedFor());
        while (StringUtils.hasLength((String)originalStateInst.getStateIdRetriedFor())) {
            int idIndex = this.getIdIndex((originalStateInst = stateInstanceMap.get(originalStateInst.getStateIdRetriedFor())).getId(), ".");
            maxIndex = idIndex > maxIndex ? idIndex : maxIndex;
            ++maxIndex;
        }
        if (originalStateInst != null) {
            originalStateInstId = originalStateInst.getId();
        }
        return originalStateInstId + "." + maxIndex;
    }

    private String generateCompensateStateInstanceId(StateInstance stateInstance, boolean isUpdateMode) {
        String originalCompensateStateInstId = stateInstance.getStateIdCompensatedFor();
        int maxIndex = 1;
        if (isUpdateMode) {
            return originalCompensateStateInstId + "-" + maxIndex;
        }
        for (int i = 0; i < stateInstance.getStateMachineInstance().getStateList().size(); ++i) {
            StateInstance aStateInstance = stateInstance.getStateMachineInstance().getStateList().get(i);
            if (aStateInstance == stateInstance || !originalCompensateStateInstId.equals(aStateInstance.getStateIdCompensatedFor())) continue;
            int idIndex = this.getIdIndex(aStateInstance.getId(), "-");
            maxIndex = idIndex > maxIndex ? idIndex : maxIndex;
            ++maxIndex;
        }
        return originalCompensateStateInstId + "-" + maxIndex;
    }

    private int getIdIndex(String stateInstanceId, String separator) {
        int start;
        if (StringUtils.hasLength((String)stateInstanceId) && (start = stateInstanceId.lastIndexOf(separator)) > 0) {
            String indexStr = stateInstanceId.substring(start + 1, stateInstanceId.length());
            try {
                return Integer.parseInt(indexStr);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("get stateInstance id index failed", (Throwable)e);
            }
        }
        return -1;
    }

    private boolean isUpdateMode(StateInstance stateInstance, ProcessContext context) {
        DefaultStateMachineConfig stateMachineConfig = (DefaultStateMachineConfig)context.getVariable("_statemachine_config_");
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        ServiceTaskStateImpl state = (ServiceTaskStateImpl)instruction.getState(context);
        StateMachine stateMachine = stateInstance.getStateMachineInstance().getStateMachine();
        if (StringUtils.hasLength((String)stateInstance.getStateIdRetriedFor())) {
            if (null != state.isRetryPersistModeUpdate()) {
                return state.isRetryPersistModeUpdate();
            }
            if (null != stateMachine.isRetryPersistModeUpdate()) {
                return stateMachine.isRetryPersistModeUpdate();
            }
            return stateMachineConfig.isSagaRetryPersistModeUpdate();
        }
        if (StringUtils.hasLength((String)stateInstance.getStateIdCompensatedFor())) {
            for (int i = 0; i < stateInstance.getStateMachineInstance().getStateList().size(); ++i) {
                StateInstance aStateInstance = stateInstance.getStateMachineInstance().getStateList().get(i);
                if (!aStateInstance.isForCompensation() || !aStateInstance.getName().equals(stateInstance.getName())) continue;
                if (null != state.isCompensatePersistModeUpdate()) {
                    return state.isCompensatePersistModeUpdate();
                }
                if (null != stateMachine.isCompensatePersistModeUpdate()) {
                    return stateMachine.isCompensatePersistModeUpdate();
                }
                return stateMachineConfig.isSagaCompensatePersistModeUpdate();
            }
            return false;
        }
        return false;
    }

    @Override
    public void recordStateFinished(StateInstance stateInstance, ProcessContext context) {
        if (stateInstance != null) {
            stateInstance.setSerializedOutputParams(this.paramsSerializer.serialize(stateInstance.getOutputParams()));
            stateInstance.setSerializedException(this.exceptionSerializer.serialize(stateInstance.getException()));
            this.executeUpdate(this.stateLogStoreSqls.getRecordStateFinishedSql(this.dbType), STATE_INSTANCE_TO_STATEMENT_FOR_UPDATE, stateInstance);
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            if (!(stateMachineConfig instanceof DbStateMachineConfig) || ((DbStateMachineConfig)stateMachineConfig).isRmReportSuccessEnable() || !ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                this.branchReport(stateInstance, context);
            }
        }
    }

    protected void branchReport(StateInstance stateInstance, ProcessContext context) {
        if (this.sagaTransactionalTemplate != null) {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            if (stateMachineConfig instanceof DbStateMachineConfig && !((DbStateMachineConfig)stateMachineConfig).isSagaBranchRegisterEnable()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("sagaBranchRegisterEnable = false, skip branch report. state[" + stateInstance.getName() + "]");
                }
                return;
            }
            BranchStatus branchStatus = null;
            StateInstance originalStateInst = null;
            if (StringUtils.hasLength((String)stateInstance.getStateIdRetriedFor())) {
                originalStateInst = this.isUpdateMode(stateInstance, context) ? stateInstance : this.findOutOriginalStateInstanceOfRetryState(stateInstance);
                branchStatus = ExecutionStatus.SU.equals((Object)stateInstance.getStatus()) ? BranchStatus.PhaseTwo_Committed : (ExecutionStatus.FA.equals((Object)stateInstance.getStatus()) || ExecutionStatus.UN.equals((Object)stateInstance.getStatus()) ? BranchStatus.PhaseOne_Failed : BranchStatus.Unknown);
            } else if (StringUtils.hasLength((String)stateInstance.getStateIdCompensatedFor())) {
                originalStateInst = this.isUpdateMode(stateInstance, context) ? stateInstance.getStateMachineInstance().getStateMap().get(stateInstance.getStateIdCompensatedFor()) : this.findOutOriginalStateInstanceOfCompensateState(stateInstance);
            }
            if (originalStateInst == null) {
                originalStateInst = stateInstance;
            }
            if (branchStatus == null) {
                branchStatus = ExecutionStatus.SU.equals((Object)originalStateInst.getStatus()) && originalStateInst.getCompensationStatus() == null ? BranchStatus.PhaseTwo_Committed : (ExecutionStatus.SU.equals((Object)originalStateInst.getCompensationStatus()) ? BranchStatus.PhaseTwo_Rollbacked : (ExecutionStatus.FA.equals((Object)originalStateInst.getCompensationStatus()) || ExecutionStatus.UN.equals((Object)originalStateInst.getCompensationStatus()) ? BranchStatus.PhaseTwo_RollbackFailed_Retryable : ((ExecutionStatus.FA.equals((Object)originalStateInst.getStatus()) || ExecutionStatus.UN.equals((Object)originalStateInst.getStatus())) && originalStateInst.getCompensationStatus() == null ? BranchStatus.PhaseOne_Failed : BranchStatus.Unknown)));
            }
            try {
                StateMachineInstance machineInstance = stateInstance.getStateMachineInstance();
                GlobalTransaction globalTransaction = this.getGlobalTransaction(machineInstance, context);
                if (globalTransaction == null) {
                    throw new EngineExecutionException("Global transaction is not exists", FrameworkErrorCode.ObjectNotExists);
                }
                this.sagaTransactionalTemplate.branchReport(globalTransaction.getXid(), Long.parseLong(originalStateInst.getId()), branchStatus, null);
            }
            catch (TransactionException e) {
                LOGGER.error("Report branch status to server error: {}, StateMachine:{}, StateName:{}, XID: {}, branchId: {}, branchStatus:{}, Reason:{} ", new Object[]{e.getCode(), originalStateInst.getStateMachineInstance().getStateMachine().getName(), originalStateInst.getName(), originalStateInst.getStateMachineInstance().getId(), originalStateInst.getId(), branchStatus, e.getMessage(), e});
            }
            catch (TransactionalExecutor.ExecutionException e) {
                LOGGER.error("Report branch status to server error: {}, StateMachine:{}, StateName:{}, XID: {}, branchId: {}, branchStatus:{}, Reason:{} ", new Object[]{e.getCode(), originalStateInst.getStateMachineInstance().getStateMachine().getName(), originalStateInst.getName(), originalStateInst.getStateMachineInstance().getId(), originalStateInst.getId(), branchStatus, e.getMessage(), e});
            }
        }
    }

    private StateInstance findOutOriginalStateInstanceOfRetryState(StateInstance stateInstance) {
        Map<String, StateInstance> stateInstanceMap = stateInstance.getStateMachineInstance().getStateMap();
        StateInstance originalStateInst = stateInstanceMap.get(stateInstance.getStateIdRetriedFor());
        while (StringUtils.hasLength((String)originalStateInst.getStateIdRetriedFor())) {
            originalStateInst = stateInstanceMap.get(originalStateInst.getStateIdRetriedFor());
        }
        return originalStateInst;
    }

    private StateInstance findOutOriginalStateInstanceOfCompensateState(StateInstance stateInstance) {
        Map<String, StateInstance> stateInstanceMap = stateInstance.getStateMachineInstance().getStateMap();
        StateInstance originalStateInst = stateInstance.getStateMachineInstance().getStateMap().get(stateInstance.getStateIdCompensatedFor());
        while (StringUtils.hasLength((String)originalStateInst.getStateIdRetriedFor())) {
            originalStateInst = stateInstanceMap.get(originalStateInst.getStateIdRetriedFor());
        }
        return originalStateInst;
    }

    @Override
    public StateMachineInstance getStateMachineInstance(String stateMachineInstanceId) {
        StateMachineInstance stateMachineInstance = this.selectOne(this.stateLogStoreSqls.getGetStateMachineInstanceByIdSql(this.dbType), RESULT_SET_TO_STATE_MACHINE_INSTANCE, stateMachineInstanceId);
        if (stateMachineInstance == null) {
            return null;
        }
        List<StateInstance> stateInstanceList = this.queryStateInstanceListByMachineInstanceId(stateMachineInstanceId);
        for (StateInstance stateInstance : stateInstanceList) {
            stateMachineInstance.putStateInstance(stateInstance.getId(), stateInstance);
        }
        this.deserializeParamsAndException(stateMachineInstance);
        return stateMachineInstance;
    }

    @Override
    public StateMachineInstance getStateMachineInstanceByBusinessKey(String businessKey, String tenantId) {
        StateMachineInstance stateMachineInstance;
        if (StringUtils.isEmpty((Object)tenantId)) {
            tenantId = this.defaultTenantId;
        }
        if ((stateMachineInstance = this.selectOne(this.stateLogStoreSqls.getGetStateMachineInstanceByBusinessKeySql(this.dbType), RESULT_SET_TO_STATE_MACHINE_INSTANCE, businessKey, tenantId)) == null) {
            return null;
        }
        List<StateInstance> stateInstanceList = this.queryStateInstanceListByMachineInstanceId(stateMachineInstance.getId());
        for (StateInstance stateInstance : stateInstanceList) {
            stateMachineInstance.putStateInstance(stateInstance.getId(), stateInstance);
        }
        this.deserializeParamsAndException(stateMachineInstance);
        return stateMachineInstance;
    }

    private void deserializeParamsAndException(StateMachineInstance stateMachineInstance) {
        String serializedEndParams;
        String serializedStartParams;
        byte[] serializedException = (byte[])stateMachineInstance.getSerializedException();
        if (serializedException != null) {
            stateMachineInstance.setException(this.exceptionSerializer.deserialize(serializedException));
        }
        if (StringUtils.hasLength((String)(serializedStartParams = (String)stateMachineInstance.getSerializedStartParams()))) {
            stateMachineInstance.setStartParams((Map)this.paramsSerializer.deserialize(serializedStartParams));
        }
        if (StringUtils.hasLength((String)(serializedEndParams = (String)stateMachineInstance.getSerializedEndParams()))) {
            stateMachineInstance.setEndParams((Map)this.paramsSerializer.deserialize(serializedEndParams));
        }
    }

    @Override
    public List<StateMachineInstance> queryStateMachineInstanceByParentId(String parentId) {
        return this.selectList(this.stateLogStoreSqls.getQueryStateMachineInstancesByParentIdSql(this.dbType), RESULT_SET_TO_STATE_MACHINE_INSTANCE, parentId);
    }

    @Override
    public StateInstance getStateInstance(String stateInstanceId, String machineInstId) {
        StateInstance stateInstance = this.selectOne(this.stateLogStoreSqls.getGetStateInstanceByIdAndMachineInstanceIdSql(this.dbType), RESULT_SET_TO_STATE_INSTANCE, machineInstId, stateInstanceId);
        this.deserializeParamsAndException(stateInstance);
        return stateInstance;
    }

    private void deserializeParamsAndException(StateInstance stateInstance) {
        if (stateInstance != null) {
            byte[] serializedException;
            String outputParams;
            String inputParams = (String)stateInstance.getSerializedInputParams();
            if (StringUtils.hasLength((String)inputParams)) {
                stateInstance.setInputParams(this.paramsSerializer.deserialize(inputParams));
            }
            if (StringUtils.hasLength((String)(outputParams = (String)stateInstance.getSerializedOutputParams()))) {
                stateInstance.setOutputParams(this.paramsSerializer.deserialize(outputParams));
            }
            if ((serializedException = (byte[])stateInstance.getSerializedException()) != null) {
                stateInstance.setException(this.exceptionSerializer.deserialize(serializedException));
            }
        }
    }

    @Override
    public List<StateInstance> queryStateInstanceListByMachineInstanceId(String stateMachineInstanceId) {
        List<StateInstance> stateInstanceList = this.selectList(this.stateLogStoreSqls.getQueryStateInstancesByMachineInstanceIdSql(this.dbType), RESULT_SET_TO_STATE_INSTANCE, stateMachineInstanceId);
        if (CollectionUtils.isEmpty(stateInstanceList)) {
            return stateInstanceList;
        }
        StateInstance lastStateInstance = CollectionUtils.getLast(stateInstanceList);
        if (lastStateInstance.getGmtEnd() == null) {
            lastStateInstance.setStatus(ExecutionStatus.RU);
        }
        HashMap<String, StateInstance> originStateMap = new HashMap<String, StateInstance>();
        HashMap<String, StateInstance> compensatedStateMap = new HashMap<String, StateInstance>();
        HashMap<String, StateInstance> retriedStateMap = new HashMap<String, StateInstance>();
        for (StateInstance tempStateInstance : stateInstanceList) {
            this.deserializeParamsAndException(tempStateInstance);
            if (StringUtils.hasText((String)tempStateInstance.getStateIdCompensatedFor())) {
                this.putLastStateToMap(compensatedStateMap, tempStateInstance, tempStateInstance.getStateIdCompensatedFor());
                continue;
            }
            if (StringUtils.hasText((String)tempStateInstance.getStateIdRetriedFor())) {
                this.putLastStateToMap(retriedStateMap, tempStateInstance, tempStateInstance.getStateIdRetriedFor());
            }
            originStateMap.put(tempStateInstance.getId(), tempStateInstance);
        }
        if (compensatedStateMap.size() != 0) {
            for (StateInstance origState : originStateMap.values()) {
                origState.setCompensationState((StateInstance)compensatedStateMap.get(origState.getId()));
            }
        }
        if (retriedStateMap.size() != 0) {
            for (StateInstance origState : originStateMap.values()) {
                if (!retriedStateMap.containsKey(origState.getId())) continue;
                origState.setIgnoreStatus(true);
            }
        }
        return stateInstanceList;
    }

    private void putLastStateToMap(Map<String, StateInstance> resultMap, StateInstance newState, String key) {
        if (!resultMap.containsKey(key)) {
            resultMap.put(key, newState);
        } else if (newState.getGmtEnd().after(resultMap.get(key).getGmtEnd())) {
            StateInstance oldState = resultMap.remove(key);
            oldState.setIgnoreStatus(true);
            resultMap.put(key, newState);
        } else {
            newState.setIgnoreStatus(true);
        }
    }

    public void setExceptionSerializer(Serializer<Exception, byte[]> exceptionSerializer) {
        this.exceptionSerializer = exceptionSerializer;
    }

    public SagaTransactionalTemplate getSagaTransactionalTemplate() {
        return this.sagaTransactionalTemplate;
    }

    public void setSagaTransactionalTemplate(SagaTransactionalTemplate sagaTransactionalTemplate) {
        this.sagaTransactionalTemplate = sagaTransactionalTemplate;
    }

    public Serializer<Object, String> getParamsSerializer() {
        return this.paramsSerializer;
    }

    public void setParamsSerializer(Serializer<Object, String> paramsSerializer) {
        this.paramsSerializer = paramsSerializer;
    }

    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    public void setDefaultTenantId(String defaultTenantId) {
        this.defaultTenantId = defaultTenantId;
    }

    public void setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
    }

    @Override
    public void setTablePrefix(String tablePrefix) {
        super.setTablePrefix(tablePrefix);
        this.stateLogStoreSqls = new StateLogStoreSqls(tablePrefix);
    }

    private static class ResultSetToStateInstance
    implements AbstractStore.ResultSetToObject<StateInstance> {
        private ResultSetToStateInstance() {
        }

        @Override
        public StateInstance toObject(ResultSet resultSet) throws SQLException {
            StateInstanceImpl stateInstance = new StateInstanceImpl();
            stateInstance.setId(resultSet.getString("id"));
            stateInstance.setMachineInstanceId(resultSet.getString("machine_inst_id"));
            stateInstance.setName(resultSet.getString("name"));
            stateInstance.setType(resultSet.getString("type"));
            stateInstance.setBusinessKey(resultSet.getString("business_key"));
            stateInstance.setStatus(ExecutionStatus.valueOf(resultSet.getString("status")));
            stateInstance.setGmtStarted(resultSet.getTimestamp("gmt_started"));
            stateInstance.setGmtEnd(resultSet.getTimestamp("gmt_end"));
            stateInstance.setServiceName(resultSet.getString("service_name"));
            stateInstance.setServiceMethod(resultSet.getString("service_method"));
            stateInstance.setServiceType(resultSet.getString("service_type"));
            stateInstance.setForUpdate(resultSet.getBoolean("is_for_update"));
            stateInstance.setStateIdCompensatedFor(resultSet.getString("state_id_compensated_for"));
            stateInstance.setStateIdRetriedFor(resultSet.getString("state_id_retried_for"));
            stateInstance.setSerializedInputParams(resultSet.getString("input_params"));
            stateInstance.setSerializedOutputParams(resultSet.getString("output_params"));
            stateInstance.setSerializedException(resultSet.getBytes("excep"));
            return stateInstance;
        }
    }

    private static class ResultSetToStateMachineInstance
    implements AbstractStore.ResultSetToObject<StateMachineInstance> {
        private ResultSetToStateMachineInstance() {
        }

        @Override
        public StateMachineInstance toObject(ResultSet resultSet) throws SQLException {
            StateMachineInstanceImpl stateMachineInstance = new StateMachineInstanceImpl();
            stateMachineInstance.setId(resultSet.getString("id"));
            stateMachineInstance.setMachineId(resultSet.getString("machine_id"));
            stateMachineInstance.setTenantId(resultSet.getString("tenant_id"));
            stateMachineInstance.setParentId(resultSet.getString("parent_id"));
            stateMachineInstance.setBusinessKey(resultSet.getString("business_key"));
            stateMachineInstance.setGmtStarted(resultSet.getTimestamp("gmt_started"));
            stateMachineInstance.setGmtEnd(resultSet.getTimestamp("gmt_end"));
            stateMachineInstance.setStatus(ExecutionStatus.valueOf(resultSet.getString("status")));
            String compensationStatusName = resultSet.getString("compensation_status");
            if (StringUtils.hasLength((String)compensationStatusName)) {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.valueOf(compensationStatusName));
            }
            stateMachineInstance.setRunning(resultSet.getBoolean("is_running"));
            stateMachineInstance.setGmtUpdated(resultSet.getTimestamp("gmt_updated"));
            if (resultSet.getMetaData().getColumnCount() > 11) {
                stateMachineInstance.setSerializedStartParams(resultSet.getString("start_params"));
                stateMachineInstance.setSerializedEndParams(resultSet.getString("end_params"));
                stateMachineInstance.setSerializedException(resultSet.getBytes("excep"));
            }
            return stateMachineInstance;
        }
    }

    private static class StateInstanceToStatementForUpdate
    implements AbstractStore.ObjectToStatement<StateInstance> {
        private StateInstanceToStatementForUpdate() {
        }

        @Override
        public void toStatement(StateInstance stateInstance, PreparedStatement statement) throws SQLException {
            statement.setTimestamp(1, new Timestamp(stateInstance.getGmtEnd().getTime()));
            statement.setBytes(2, stateInstance.getException() != null ? (byte[])stateInstance.getSerializedException() : null);
            statement.setString(3, stateInstance.getStatus().name());
            statement.setObject(4, stateInstance.getSerializedOutputParams());
            statement.setTimestamp(5, new Timestamp(stateInstance.getGmtEnd().getTime()));
            statement.setString(6, stateInstance.getId());
            statement.setString(7, stateInstance.getMachineInstanceId());
        }
    }

    private static class StateInstanceToStatementForInsert
    implements AbstractStore.ObjectToStatement<StateInstance> {
        private StateInstanceToStatementForInsert() {
        }

        @Override
        public void toStatement(StateInstance stateInstance, PreparedStatement statement) throws SQLException {
            statement.setString(1, stateInstance.getId());
            statement.setString(2, stateInstance.getMachineInstanceId());
            statement.setString(3, stateInstance.getName());
            statement.setString(4, stateInstance.getType());
            statement.setTimestamp(5, new Timestamp(stateInstance.getGmtStarted().getTime()));
            statement.setString(6, stateInstance.getServiceName());
            statement.setString(7, stateInstance.getServiceMethod());
            statement.setString(8, stateInstance.getServiceType());
            statement.setBoolean(9, stateInstance.isForUpdate());
            statement.setObject(10, stateInstance.getSerializedInputParams());
            statement.setString(11, stateInstance.getStatus().name());
            statement.setString(12, stateInstance.getBusinessKey());
            statement.setString(13, stateInstance.getStateIdCompensatedFor());
            statement.setString(14, stateInstance.getStateIdRetriedFor());
            statement.setTimestamp(15, new Timestamp(stateInstance.getGmtUpdated().getTime()));
        }
    }

    private static class StateMachineInstanceToStatementForUpdate
    implements AbstractStore.ObjectToStatement<StateMachineInstance> {
        private StateMachineInstanceToStatementForUpdate() {
        }

        @Override
        public void toStatement(StateMachineInstance stateMachineInstance, PreparedStatement statement) throws SQLException {
            statement.setTimestamp(1, new Timestamp(stateMachineInstance.getGmtEnd().getTime()));
            statement.setBytes(2, stateMachineInstance.getSerializedException() != null ? (byte[])stateMachineInstance.getSerializedException() : null);
            statement.setObject(3, stateMachineInstance.getSerializedEndParams());
            statement.setString(4, stateMachineInstance.getStatus().name());
            statement.setString(5, stateMachineInstance.getCompensationStatus() != null ? stateMachineInstance.getCompensationStatus().name() : null);
            statement.setBoolean(6, stateMachineInstance.isRunning());
            statement.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            statement.setString(8, stateMachineInstance.getId());
            statement.setTimestamp(9, new Timestamp(stateMachineInstance.getGmtUpdated().getTime()));
        }
    }

    private static class StateMachineInstanceToStatementForInsert
    implements AbstractStore.ObjectToStatement<StateMachineInstance> {
        private StateMachineInstanceToStatementForInsert() {
        }

        @Override
        public void toStatement(StateMachineInstance stateMachineInstance, PreparedStatement statement) throws SQLException {
            statement.setString(1, stateMachineInstance.getId());
            statement.setString(2, stateMachineInstance.getMachineId());
            statement.setString(3, stateMachineInstance.getTenantId());
            statement.setString(4, stateMachineInstance.getParentId());
            statement.setTimestamp(5, new Timestamp(stateMachineInstance.getGmtStarted().getTime()));
            statement.setString(6, stateMachineInstance.getBusinessKey());
            statement.setObject(7, stateMachineInstance.getSerializedStartParams());
            statement.setBoolean(8, stateMachineInstance.isRunning());
            statement.setString(9, stateMachineInstance.getStatus().name());
            statement.setTimestamp(10, new Timestamp(stateMachineInstance.getGmtUpdated().getTime()));
        }
    }
}

