/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.oscar.keyword;

import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.KeywordChecker;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

@LoadLevel(name="oscar")
public class OscarKeywordChecker
implements KeywordChecker {
    private Set<String> keywordSet = Arrays.stream(OscarKeyword.values()).map(Enum::name).collect(Collectors.toSet());

    @Override
    public boolean check(String fieldOrTableName) {
        if (this.keywordSet.contains(fieldOrTableName)) {
            return true;
        }
        if (fieldOrTableName != null) {
            fieldOrTableName = fieldOrTableName.toUpperCase();
        }
        return this.keywordSet.contains(fieldOrTableName);
    }

    @Override
    public boolean checkEscape(String fieldOrTableName) {
        boolean check = this.check(fieldOrTableName);
        return check || !OscarKeywordChecker.isUppercase(fieldOrTableName);
    }

    private static boolean isUppercase(String fieldOrTableName) {
        char[] chars;
        if (fieldOrTableName == null) {
            return false;
        }
        for (char ch : chars = fieldOrTableName.toCharArray()) {
            if (ch < 'a' || ch > 'z') continue;
            return false;
        }
        return true;
    }

    private static enum OscarKeyword {
        ACTION("ACTION"),
        ADD("ADD"),
        AFTER("AFTER"),
        AGGREGATE("AGGREGATE"),
        ALL("ALL"),
        ALTER("ALTER"),
        ANALYSE("ANALYSE"),
        ANALYZE("ANALYZE"),
        AND("AND"),
        ANY("ANY"),
        ARCHIVELOG("ARCHIVELOG"),
        AS("AS"),
        ASC("ASC"),
        ASSERTION("ASSERTION"),
        ASSIGNMENT("ASSIGNMENT"),
        AT("AT"),
        AUDIT("AUDIT"),
        AUTHORIZATION("AUTHORIZATION"),
        AUTOEXTEND("AUTOEXTEND"),
        ALLOCATE("ALLOCATE"),
        AUTOCOMMIT("AUTOCOMMIT"),
        BACKWARD("BACKWARD"),
        BEFORE("BEFORE"),
        BEGIN("BEGIN"),
        BETWEEN("BETWEEN"),
        BIGINT("BIGINT"),
        BINARY("BINARY"),
        BIT("BIT"),
        BLOCK("BLOCK"),
        BOOLEAN("BOOLEAN"),
        BOTH("BOTH"),
        BY("BY"),
        BOOL("BOOL"),
        CACHE("CACHE"),
        CALL("CALL"),
        CALLED("CALLED"),
        CASCADE("CASCADE"),
        CASCADED("CASCADED"),
        CASE("CASE"),
        CAST("CAST"),
        CHAIN("CHAIN"),
        CHAR("CHAR"),
        CHARACTER("CHARACTER"),
        CHARACTERISTICS("CHARACTERISTICS"),
        CHECK("CHECK"),
        CHECKPOINT("CHECKPOINT"),
        CLASS("CLASS"),
        CLEAN("CLEAN"),
        CLOSE("CLOSE"),
        CLUSTER("CLUSTER"),
        COALESCE("COALESCE"),
        COLLATE("COLLATE"),
        COLUMN("COLUMN"),
        COMMENT("COMMENT"),
        COMMIT("COMMIT"),
        COMMITTED("COMMITTED"),
        CONFIGURATION("CONFIGURATION"),
        CONSTRAINT("CONSTRAINT"),
        CONSTRAINTS("CONSTRAINTS"),
        CONTROLFILE("CONTROLFILE"),
        CONVERSION("CONVERSION"),
        CONVERT("CONVERT"),
        COPY("COPY"),
        CREATE("CREATE"),
        CREATEDB("CREATEDB"),
        CREATEUSER("CREATEUSER"),
        CROSS("CROSS"),
        CURRENT("CURRENT"),
        CURRENTDATE("CURRENTDATE"),
        CURRENTTIME("CURRENTTIME"),
        CURRENTTIMESTAMP("CURRENTTIMESTAMP"),
        CURRENTUSER("CURRENTUSER"),
        CURSOR("CURSOR"),
        CYCLE("CYCLE"),
        CONNECTION("CONNECTION"),
        DATABASE("DATABASE"),
        DATAFILE("DATAFILE"),
        DAY("DAY"),
        DBA("DBA"),
        DEALLOCATE("DEALLOCATE"),
        DEBUG("DEBUG"),
        DEC("DEC"),
        DECIMAL("DECIMAL"),
        DECLARE("DECLARE"),
        DEFAULT("DEFAULT"),
        DEFERRABLE("DEFERRABLE"),
        DEFERRED("DEFERRED"),
        DEFINER("DEFINER"),
        DELETE("DELETE"),
        DELIMITER("DELIMITER"),
        DELIMITERS("DELIMITERS"),
        DESC("DESC"),
        DESCRIPTION("DESCRIPTION"),
        DISTINCT("DISTINCT"),
        DO("DO"),
        DOMAIN("DOMAIN"),
        DOUBLE("DOUBLE"),
        DROP("DROP"),
        DESCRIPTOR("DESCRIPTOR"),
        EACH("EACH"),
        ELSE("ELSE"),
        ENCODING("ENCODING"),
        ENCRYPTED("ENCRYPTED"),
        END("END"),
        ESCAPE("ESCAPE"),
        EXCEPT("EXCEPT"),
        EXCLUSIVE("EXCLUSIVE"),
        EXEC("EXEC"),
        EXECUTE("EXECUTE"),
        EXISTS("EXISTS"),
        EXPLAIN("EXPLAIN"),
        EXTERNAL("EXTERNAL"),
        EXTRACT("EXTRACT"),
        ENUM("ENUM"),
        FALSE("FALSE"),
        FETCH("FETCH"),
        FILE("FILE"),
        FILL("FILL"),
        FLOAT("FLOAT"),
        FOR("FOR"),
        FORCE("FORCE"),
        FOREIGN("FOREIGN"),
        FORWARD("FORWARD"),
        FREEZE("FREEZE"),
        FROM("FROM"),
        FULL("FULL"),
        FUNCTION("FUNCTION"),
        FREE("FREE"),
        GET("GET"),
        GLOBAL("GLOBAL"),
        GLOBALNAME("GLOBALNAME"),
        GRANT("GRANT"),
        GROUP("GROUP"),
        HANDLER("HANDLER"),
        HAVING("HAVING"),
        HOUR("HOUR"),
        ILIKE("ILIKE"),
        IMMEDIATE("IMMEDIATE"),
        IMMUTABLE("IMMUTABLE"),
        IMPLICIT("IMPLICIT"),
        IMPORT("IMPORT"),
        IN("IN"),
        INCREMENT("INCREMENT"),
        INDEX("INDEX"),
        INHERITS("INHERITS"),
        INIT("INIT"),
        INITIALLY("INITIALLY"),
        INNER("INNER"),
        INOUT("INOUT"),
        INPUT("INPUT "),
        INSENSITIVE("INSENSITIVE"),
        INSERT("INSERT"),
        INSTEAD("INSTEAD"),
        INT("INT"),
        INTEGER("INTEGER"),
        INTERSECT("INTERSECT"),
        INTERVAL("INTERVAL"),
        INTO("INTO"),
        INVOKER("INVOKER"),
        IS("IS"),
        ISNULL("ISNULL"),
        ISOLATION("ISOLATION"),
        INDICATOR("INDICATOR"),
        JOIN("JOIN"),
        KEY("KEY"),
        KILL("KILL"),
        LANCOMPILER("LANCOMPILER"),
        LANGUAGE("LANGUAGE"),
        LEADING("LEADING"),
        LEFT("LEFT"),
        LEVEL("LEVEL "),
        LIKE("LIKE"),
        LIMIT("LIMIT"),
        LISTEN("LISTEN"),
        LOAD("LOAD"),
        LOCAL("LOCAL "),
        LOCALTIME("LOCALTIME"),
        LOCALTIMESTAMP("LOCALTIMESTAMP"),
        LOCATION("LOCATION"),
        LOCK("LOCK"),
        LOGFILE("LOGFILE"),
        LOGGING("LOGGING"),
        LOGICAL("LOGICAL"),
        LONG("LONG"),
        MATCH("MATCH"),
        MAXSIZE("MAXSIZE"),
        MAXVALUE("MAXVALUE"),
        MEMBER("MEMBER"),
        MINUTE("MINUTE"),
        MINVALUE("MINVALUE"),
        MODE("MODE"),
        MONTH("MONTH"),
        MOUNT("MOUNT"),
        MOVE("MOVE"),
        MULTIPLE("MULTIPLE"),
        NAMES("NAMES"),
        NATIONAL("NATIONAL"),
        NATURAL("NATURAL"),
        NCHAR("NCHAR"),
        NEW("NEW"),
        NEXT("NEXT"),
        NO("NO"),
        NOARCHIVELOG("NOARCHIVELOG"),
        NOAUDIT("NOAUDIT"),
        NOCREATEDB("NOCREATEDB"),
        NOCREATEUSER("NOCREATEUSER"),
        NOLOGGING("NOLOGGING"),
        NOMOUNT("NOMOUNT"),
        NONE("NONE"),
        NORECOMPUTE("NORECOMPUTE"),
        NORMAL("NORMAL"),
        NOT("NOT"),
        NOTHING("NOTHING"),
        NOTIFY("NOTIFY"),
        NOTNULL("NOTNULL"),
        NULL("NULL"),
        NULLIF("NULLIF"),
        NUMERIC("NUMERIC"),
        OBJECT("OBJECT"),
        OF("OF"),
        OFF("OFF"),
        OFFSET("OFFSET"),
        OIDS("OIDS"),
        OLD("OLD"),
        ON("ON"),
        ONLY("ONLY"),
        OPEN("OPEN"),
        OPERATOR("OPERATOR"),
        OPTION("OPTION"),
        OR("OR"),
        ORDER("ORDER"),
        OUT("OUT"),
        OUTER("OUTER"),
        OVERLAPS("OVERLAPS"),
        OVERLAY("OVERLAY"),
        OWNER("OWNER"),
        OUTPUT("OUTPUT"),
        PARAMETER("PARAMETER"),
        PARAMINFO("PARAMINFO"),
        PARTIAL("PARTIAL"),
        PARTITION("PARTITION"),
        PASSWORD("PASSWORD"),
        PATH("PATH"),
        PCTFREE("PCTFREE"),
        PCTUSED("PCTUSED"),
        PENDANT("PENDANT"),
        PERCENT("PERCENT"),
        PFILE("PFILE"),
        PLACING("PLACING"),
        POSITION("POSITION"),
        PRECISION("PRECISION"),
        PREPARE("PREPARE"),
        PRIMARY("PRIMARY"),
        PRIOR("PRIOR"),
        PRIVILEGES("PRIVILEGES"),
        PROCEDURAL("PROCEDURAL"),
        PROCEDURE("PROCEDURE"),
        READ("READ"),
        REAL("REAL"),
        REBUILD("REBUILD"),
        RECHECK("RECHECK"),
        RECOVERY("RECOVERY"),
        REFERENCES("REFERENCES"),
        RELATIVE("RELATIVE"),
        RENAME("RENAME"),
        REPEATABLE("REPEATABLE"),
        REPLACE("REPLACE"),
        RESET("RESET"),
        RESIZE("RESIZE"),
        RESTRICT("RESTRICT"),
        RETURN("RETURN"),
        RETURNS("RETURNS"),
        REUSE("REUSE"),
        REVOKE("REVOKE"),
        RIGHT("RIGHT"),
        ROLE("ROLE"),
        ROLLBACK("ROLLBACK"),
        ROW("ROW"),
        ROWDESCRIPTION("ROWDESCRIPTION"),
        RULE("RULE"),
        REFERENCE("REFERENCE"),
        SAVEPOINT("SAVEPOINT"),
        SCAN("SCAN"),
        SCHEMA("SCHEMA"),
        SCROLL("SCROLL"),
        SECOND("SECOND"),
        SECURITY("SECURITY"),
        SELECT("SELECT"),
        SEQUENCE("SEQUENCE"),
        SERIALIZABLE("SERIALIZABLE"),
        SESSION("SESSION"),
        SESSIONUSER("SESSIONUSER"),
        SET("SET"),
        SETOF("SETOF"),
        SHARE("SHARE"),
        SHOW("SHOW"),
        SHUTDOWN("SHUTDOWN"),
        SIMILAR("SIMILAR"),
        SIMPLE("SIMPLE"),
        SINGLE("SINGLE"),
        SIZE("SIZE"),
        SMALLINT("SMALLINT"),
        SOME("SOME"),
        SPLIT("SPLIT"),
        STABLE("STABLE"),
        START("START"),
        STARTUP("STARTUP"),
        STATEMENT("STATEMENT"),
        STATIC("STATIC"),
        STATISTICS("STATISTICS"),
        STDIN("STDIN"),
        STDOUT("STDOUT"),
        STORAGE("STORAGE"),
        STRICT("STRICT"),
        SUBSTRING("SUBSTRING"),
        SUCCESSFUL("SUCCESSFUL"),
        SYSID("SYSID"),
        SYSTEM("SYSTEM"),
        STRUCT("STRUCT"),
        SHORT("SHORT"),
        SIGNED("SIGNED"),
        SQL("SQL"),
        TABLE("TABLE"),
        TABLESPACE("TABLESPACE"),
        TEMP("TEMP"),
        TEMPLATE("TEMPLATE"),
        TEMPORARY("TEMPORARY"),
        THEN("THEN"),
        TIME("TIME"),
        TIMESTAMP("TIMESTAMP"),
        TINYINT("TINYINT"),
        TO("TO"),
        TOAST("TOAST"),
        TRAIL("TRAIL"),
        TRAILING("TRAILING"),
        TRANSACTION("TRANSACTION"),
        TRANSACTIONAL("TRANSACTIONAL"),
        THREAT("THREAT"),
        TRIGGER("TRIGGER"),
        TRIM("TRIM"),
        TRUE("TRUE"),
        TRUNCATE("TRUNCATE"),
        TRUSTED("TRUSTED"),
        TUPLE("TUPLE"),
        TYPE("TYPE"),
        UNENCRYPTED("UNENCRYPTED"),
        UNION("UNION"),
        UNIQUE("UNIQUE"),
        UNKOWN("UNKOWN"),
        UNLIMITED("UNLIMITED"),
        UNLISTEN("UNLISTEN"),
        UNLOCK("UNLOCK"),
        UNTIL("UNTIL"),
        UP("UP"),
        UPDATE("UPDATE"),
        USAGE("USAGE"),
        USER("USER"),
        USING("USING"),
        UNSIGNED("UNSIGNED"),
        VACUUM("VACUUM"),
        VALID("VALID"),
        VALIDATOR("VALIDATOR"),
        VALUES("VALUES"),
        VARBINARY("VARBINARY"),
        VARCHAR("VARCHAR"),
        VARYING("VARYING"),
        VERBOSE("VERBOSE"),
        VERSION("VERSION"),
        VOLATILE("VOLATILE"),
        VALUE("VALUE"),
        WHEN("WHEN"),
        WHENEVER("WHENEVER"),
        WHERE("WHERE"),
        WITH("WITH"),
        WITHOUT("WITHOUT"),
        WORK("WORK"),
        WRITE("WRITE"),
        YEAR("YEAR");

        public final String name;

        private OscarKeyword(String name) {
            this.name = name;
        }
    }
}

