/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.undo.UndoLogConstants;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UndoLogParserFactory {
    private static final ConcurrentMap<String, UndoLogParser> INSTANCES = new ConcurrentHashMap<String, UndoLogParser>();

    private UndoLogParserFactory() {
    }

    public static UndoLogParser getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static UndoLogParser getInstance(String name) {
        return CollectionUtils.computeIfAbsent(INSTANCES, name, key -> EnhancedServiceLoader.load(UndoLogParser.class, name));
    }

    private static class SingletonHolder {
        private static final UndoLogParser INSTANCE = UndoLogParserFactory.getInstance(UndoLogConstants.DEFAULT_SERIALIZER);

        private SingletonHolder() {
        }
    }
}

