/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.util;

import io.seata.common.util.CollectionUtils;
import io.seata.rm.tcc.remoting.parser.DubboUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;

public class SpringProxyUtils {
    private SpringProxyUtils() {
    }

    public static Class<?> findTargetClass(Object proxy) throws Exception {
        if (proxy == null) {
            return null;
        }
        if (AopUtils.isAopProxy((Object)proxy) && proxy instanceof Advised) {
            Object targetObject = ((Advised)proxy).getTargetSource().getTarget();
            return SpringProxyUtils.findTargetClass(targetObject);
        }
        return proxy.getClass();
    }

    public static Class<?>[] findInterfaces(Object proxy) throws Exception {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            AdvisedSupport advised = SpringProxyUtils.getAdvisedSupport(proxy);
            return SpringProxyUtils.getInterfacesByAdvised(advised);
        }
        return new Class[0];
    }

    private static Class<?>[] getInterfacesByAdvised(AdvisedSupport advised) {
        Class[] interfaces = advised.getProxiedInterfaces();
        if (interfaces.length > 0) {
            return interfaces;
        }
        throw new IllegalStateException("Find the jdk dynamic proxy class that does not implement the interface");
    }

    public static AdvisedSupport getAdvisedSupport(Object proxy) throws Exception {
        Field h = AopUtils.isJdkDynamicProxy((Object)proxy) ? proxy.getClass().getSuperclass().getDeclaredField("h") : proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return (AdvisedSupport)advised.get(dynamicAdvisedInterceptor);
    }

    public static boolean isProxy(Object bean) {
        if (bean == null) {
            return false;
        }
        return DubboUtil.isDubboProxyName(bean.getClass().getName()) || Proxy.class.isAssignableFrom(bean.getClass()) || AopUtils.isAopProxy((Object)bean);
    }

    public static Class<?> getTargetInterface(Object proxy) throws Exception {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy can not be null");
        }
        if (Proxy.class.isAssignableFrom(proxy.getClass())) {
            Proxy p = (Proxy)proxy;
            return p.getClass().getInterfaces()[0];
        }
        return SpringProxyUtils.getTargetClass(proxy);
    }

    protected static Class<?> getTargetClass(Object proxy) throws Exception {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy can not be null");
        }
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy.getClass();
        }
        AdvisedSupport advisedSupport = SpringProxyUtils.getAdvisedSupport(proxy);
        Object target = advisedSupport.getTargetSource().getTarget();
        if (target == null) {
            if (CollectionUtils.isNotEmpty(advisedSupport.getProxiedInterfaces())) {
                return advisedSupport.getProxiedInterfaces()[0];
            }
            return proxy.getClass();
        }
        return SpringProxyUtils.getTargetClass(target);
    }

    public static Class<?>[] getAllInterfaces(Object bean) {
        HashSet interfaces = new HashSet();
        if (bean != null) {
            Class<?> clazz = bean.getClass();
            while (!Object.class.getName().equalsIgnoreCase(clazz.getName())) {
                Class<?>[] clazzInterfaces = clazz.getInterfaces();
                interfaces.addAll(Arrays.asList(clazzInterfaces));
                clazz = clazz.getSuperclass();
            }
        }
        return interfaces.toArray(new Class[0]);
    }
}

