/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct.cache;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.ColumnUtils;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.IndexMeta;
import io.seata.rm.datasource.sql.struct.IndexType;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.cache.AbstractTableMetaCache;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="kingbase")
public class KingBaseTableMetaCache
extends AbstractTableMetaCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(KingBaseTableMetaCache.class);

    @Override
    protected String getCacheKey(Connection connection, String tableName, String resourceId) {
        StringBuilder cacheKey = new StringBuilder(resourceId);
        cacheKey.append(".");
        String[] tableNameWithCatalog = tableName.replace("`", "").split("\\.");
        String defaultTableName = tableNameWithCatalog.length > 1 ? tableNameWithCatalog[1] : tableNameWithCatalog[0];
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException var10) {
            LOGGER.error("Could not get connection, use default cache key {}", (Object)var10.getMessage(), (Object)var10);
            return cacheKey.append(defaultTableName).toString();
        }
        try {
            if (databaseMetaData.supportsMixedCaseIdentifiers()) {
                cacheKey.append(defaultTableName);
            } else {
                cacheKey.append(defaultTableName.toLowerCase());
            }
        }
        catch (SQLException var9) {
            LOGGER.error("Could not get supportsMixedCaseIdentifiers in connection metadata, use default cache key {}", (Object)var9.getMessage(), (Object)var9);
            return cacheKey.append(defaultTableName).toString();
        }
        return cacheKey.toString();
    }

    @Override
    protected TableMeta fetchSchema(Connection connection, String tableName) throws SQLException {
        String sql = "SELECT * FROM " + ColumnUtils.addEscape(tableName, "mysql") + " LIMIT 1";
        try {
            TableMeta var8;
            try (Statement stmt = connection.createStatement();){
                Throwable var7 = null;
                try (ResultSet rs = stmt.executeQuery(sql);){
                    var8 = this.resultSetMetaToSchema(rs.getMetaData(), connection.getMetaData());
                }
                catch (Throwable var35) {
                    Throwable var82 = var35;
                    var7 = var35;
                    throw var35;
                }
            }
            return var8;
        }
        catch (SQLException var39) {
            throw var39;
        }
        catch (Exception var40) {
            throw new SQLException(String.format("Failed to fetch schema of %s", tableName), var40);
        }
    }

    private TableMeta resultSetMetaToSchema(ResultSetMetaData rsmd, DatabaseMetaData dbmd) throws SQLException {
        String schemaName = rsmd.getSchemaName(1);
        String catalogName = rsmd.getCatalogName(1);
        String tableName = rsmd.getTableName(1);
        TableMeta tm = new TableMeta();
        tm.setTableName(tableName);
        Throwable var8 = null;
        try (ResultSet rsColumns = dbmd.getColumns(catalogName, schemaName, tableName, "%");){
            Throwable var10;
            ResultSet rsIndex;
            block33: {
                TableMeta tableMeta;
                block34: {
                    block35: {
                        String indexName;
                        rsIndex = dbmd.getIndexInfo(catalogName, schemaName, tableName, false, true);
                        var10 = null;
                        ResultSet rsPrimary = dbmd.getPrimaryKeys(null, schemaName, tableName);
                        while (rsColumns.next()) {
                            ColumnMeta col = new ColumnMeta();
                            col.setTableCat(rsColumns.getString("TABLE_CAT"));
                            col.setTableSchemaName(rsColumns.getString("TABLE_SCHEM"));
                            col.setTableName(rsColumns.getString("TABLE_NAME"));
                            col.setColumnName(rsColumns.getString("COLUMN_NAME"));
                            col.setDataType(rsColumns.getInt("DATA_TYPE"));
                            col.setDataTypeName(rsColumns.getString("TYPE_NAME"));
                            col.setColumnSize(rsColumns.getInt("COLUMN_SIZE"));
                            col.setDecimalDigits(rsColumns.getInt("DECIMAL_DIGITS"));
                            col.setNumPrecRadix(rsColumns.getInt("NUM_PREC_RADIX"));
                            col.setNullAble(rsColumns.getInt("NULLABLE"));
                            col.setRemarks(rsColumns.getString("REMARKS"));
                            col.setColumnDef(rsColumns.getString("COLUMN_DEF"));
                            col.setSqlDataType(rsColumns.getInt("SQL_DATA_TYPE"));
                            col.setSqlDatetimeSub(rsColumns.getInt("SQL_DATETIME_SUB"));
                            col.setCharOctetLength(rsColumns.getInt("CHAR_OCTET_LENGTH"));
                            col.setOrdinalPosition(rsColumns.getInt("ORDINAL_POSITION"));
                            col.setIsNullAble(rsColumns.getString("IS_NULLABLE"));
                            col.setIsAutoincrement(rsColumns.getString("IS_AUTOINCREMENT"));
                            tm.getAllColumns().put(col.getColumnName(), col);
                        }
                        while (rsIndex.next()) {
                            IndexMeta index;
                            indexName = rsIndex.getString("INDEX_NAME");
                            String colName = rsIndex.getString("COLUMN_NAME");
                            ColumnMeta col = tm.getAllColumns().get(colName);
                            if (tm.getAllIndexes().containsKey(indexName)) {
                                index = tm.getAllIndexes().get(indexName);
                                index.getValues().add(col);
                                continue;
                            }
                            index = new IndexMeta();
                            index.setIndexName(indexName);
                            index.setNonUnique(rsIndex.getBoolean("NON_UNIQUE"));
                            index.setIndexQualifier(rsIndex.getString("INDEX_QUALIFIER"));
                            index.setIndexName(rsIndex.getString("INDEX_NAME"));
                            index.setType(rsIndex.getShort("TYPE"));
                            index.setOrdinalPosition(rsIndex.getShort("ORDINAL_POSITION"));
                            index.setAscOrDesc(rsIndex.getString("ASC_OR_DESC"));
                            index.setCardinality(rsIndex.getInt("CARDINALITY"));
                            index.getValues().add(col);
                            if ("PRIMARY".equalsIgnoreCase(indexName)) {
                                index.setIndextype(IndexType.PRIMARY);
                            } else if (!index.isNonUnique()) {
                                index.setIndextype(IndexType.UNIQUE);
                            } else {
                                index.setIndextype(IndexType.NORMAL);
                            }
                            tm.getAllIndexes().put(indexName, index);
                        }
                        while (rsPrimary.next()) {
                            indexName = rsPrimary.getString("pk_name");
                            if (!tm.getAllIndexes().containsKey(indexName)) continue;
                            IndexMeta index = tm.getAllIndexes().get(indexName);
                            index.setIndextype(IndexType.PRIMARY);
                        }
                        if (tm.getAllIndexes().isEmpty()) break block33;
                        tableMeta = tm;
                        if (rsIndex == null) break block34;
                        if (var10 == null) break block35;
                        try {
                            rsIndex.close();
                        }
                        catch (Throwable var35) {
                            var10.addSuppressed(var35);
                        }
                        break block34;
                    }
                    rsIndex.close();
                }
                return tableMeta;
            }
            try {
                try {
                    try {
                        throw new ShouldNeverHappenException("Could not found any index in the table: " + tableName);
                    }
                    catch (Throwable var36) {
                        var10 = var36;
                        throw var36;
                    }
                }
                catch (Throwable throwable) {
                    if (rsIndex != null) {
                        if (var10 != null) {
                            try {
                                rsIndex.close();
                            }
                            catch (Throwable var35) {
                                var10.addSuppressed(var35);
                            }
                        } else {
                            rsIndex.close();
                        }
                    }
                    throw throwable;
                }
            }
            catch (Throwable var38) {
                var8 = var38;
                throw var38;
            }
        }
    }
}

