/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.kingbase;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.ColumnUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class KingBaseUndoDeleteExecutor
extends AbstractUndoExecutor {
    private static final String INSERT_SQL_TEMPLATE = "INSERT INTO %s (%s) VALUES (%s)";

    public KingBaseUndoDeleteExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (CollectionUtils.isEmpty(beforeImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        ArrayList<Field> fields = new ArrayList<Field>(row.nonPrimaryKeys());
        fields.addAll(this.getOrderedPkList(beforeImage, row, "kingbase"));
        String insertColumns = fields.stream().map(field -> ColumnUtils.addEscape(field.getName(), "kingbase")).collect(Collectors.joining(", "));
        String insertValues = fields.stream().map(field -> "?").collect(Collectors.joining(", "));
        return String.format(INSERT_SQL_TEMPLATE, this.sqlUndoLog.getTableName(), insertColumns, insertValues);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

