/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.datasource;

import io.seata.rm.datasource.DataSourceProxy;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DataSourceProxyHolder {
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ConcurrentHashMap<DataSource, DataSourceProxy> dataSourceProxyMap = new ConcurrentHashMap(8);

    private DataSourceProxyHolder() {
    }

    public static DataSourceProxyHolder get() {
        return Holder.INSTANCE;
    }

    public DataSourceProxy putDataSource(DataSource dataSource) {
        return this.dataSourceProxyMap.computeIfAbsent(dataSource, DataSourceProxy::new);
    }

    public DataSourceProxy getDataSourceProxy(DataSource dataSource) {
        return this.dataSourceProxyMap.get(dataSource);
    }

    private static class Holder {
        private static final DataSourceProxyHolder INSTANCE = new DataSourceProxyHolder();

        private Holder() {
        }
    }
}

