/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.interceptor;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.StringUtils;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionContextUtil {
    private ActionContextUtil() {
    }

    public static Map<String, Object> fetchContextFromObject(Object targetParam) {
        try {
            HashMap<String, Object> context = new HashMap<String, Object>(8);
            ArrayList<Field> fields = new ArrayList<Field>();
            ActionContextUtil.getAllField(targetParam.getClass(), fields);
            for (Field f : fields) {
                String fieldName = f.getName();
                BusinessActionContextParameter annotation = f.getAnnotation(BusinessActionContextParameter.class);
                if (annotation == null) continue;
                f.setAccessible(true);
                Object paramObject = f.get(targetParam);
                int index = annotation.index();
                if (index >= 0) {
                    Object targetObject = ((List)paramObject).get(index);
                    if (annotation.isParamInProperty()) {
                        context.putAll(ActionContextUtil.fetchContextFromObject(targetObject));
                        continue;
                    }
                    if (StringUtils.isBlank(annotation.paramName())) {
                        context.put(fieldName, paramObject);
                        continue;
                    }
                    context.put(annotation.paramName(), paramObject);
                    continue;
                }
                if (annotation.isParamInProperty()) {
                    context.putAll(ActionContextUtil.fetchContextFromObject(paramObject));
                    continue;
                }
                if (StringUtils.isBlank(annotation.paramName())) {
                    context.put(fieldName, paramObject);
                    continue;
                }
                context.put(annotation.paramName(), paramObject);
            }
            return context;
        }
        catch (Throwable t) {
            throw new FrameworkException(t, "fetchContextFromObject failover");
        }
    }

    public static void getAllField(Class<?> interFace, List<Field> fields) {
        if (interFace == Object.class || interFace.isInterface()) {
            return;
        }
        Field[] field = interFace.getDeclaredFields();
        fields.addAll(Arrays.asList(field));
        ActionContextUtil.getAllField(interFace.getSuperclass(), fields);
    }
}

