/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.ConfigurationFactory;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.AbstractDataSourceProxy;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import io.seata.rm.datasource.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private String resourceGroupId;
    private static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT";
    private String jdbcUrl;
    private String dbType;
    private static boolean ENABLE_TABLE_META_CHECKER_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.rm.tableMetaCheckEnable", false);
    private static final long TABLE_META_CHECKER_INTERVAL = 60000L;
    private final ScheduledExecutorService tableMetaExcutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("tableMetaChecker", 1, true));

    public DataSourceProxy(DataSource targetDataSource) {
        this(targetDataSource, DEFAULT_RESOURCE_GROUP_ID);
    }

    public DataSourceProxy(DataSource targetDataSource, String resourceGroupId) {
        super(targetDataSource);
        this.init(targetDataSource, resourceGroupId);
    }

    private void init(DataSource dataSource, String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType(this.jdbcUrl);
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
        DefaultResourceManager.get().registerResource(this);
        if (ENABLE_TABLE_META_CHECKER_ENABLE) {
            this.tableMetaExcutor.scheduleAtFixedRate(() -> {
                try (Connection connection = dataSource.getConnection();){
                    TableMetaCacheFactory.getTableMetaCache(this.getDbType()).refresh(connection, this.getResourceId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 0L, 60000L, TimeUnit.MILLISECONDS);
        }
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    @Override
    public String getResourceId() {
        if (this.jdbcUrl.contains("?")) {
            return this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63));
        }
        return this.jdbcUrl;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

