/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.seata.core.protocol.HeartbeatMessage;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.rpc.ChannelManager;
import io.seata.core.rpc.DefaultServerMessageListenerImpl;
import io.seata.core.rpc.netty.AbstractRpcRemotingServer;
import io.seata.core.rpc.netty.NettyServerConfig;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
extends AbstractRpcRemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServer.class);

    public RpcServer(ThreadPoolExecutor messageExecutor) {
        super(messageExecutor, new NettyServerConfig());
    }

    @Override
    public void init() {
        DefaultServerMessageListenerImpl defaultServerMessageListenerImpl = new DefaultServerMessageListenerImpl(this.getTransactionMessageHandler());
        defaultServerMessageListenerImpl.init();
        defaultServerMessageListenerImpl.setServerMessageSender(this);
        super.setServerMessageListener(defaultServerMessageListenerImpl);
        super.setChannelHandlers(new ChannelHandler[]{new AbstractRpcRemotingServer.ServerHandler(this)});
        super.init();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("destroyed rpcServer");
        }
    }

    @Override
    public void sendResponse(RpcMessage request, Channel channel, Object msg) {
        Channel clientChannel = channel;
        if (!(msg instanceof HeartbeatMessage)) {
            clientChannel = ChannelManager.getSameClientChannel(channel);
        }
        if (clientChannel == null) {
            throw new RuntimeException("channel is error. channel:" + clientChannel);
        }
        super.defaultSendResponse(request, clientChannel, msg);
    }

    @Override
    public Object sendSyncRequest(String resourceId, String clientId, Object message, long timeout) throws TimeoutException {
        Channel clientChannel = ChannelManager.getChannel(resourceId, clientId);
        if (clientChannel == null) {
            throw new RuntimeException("rm client is not connected. dbkey:" + resourceId + ",clientId:" + clientId);
        }
        return this.sendAsyncRequestWithResponse(null, clientChannel, message, timeout);
    }

    @Override
    public Object sendSyncRequest(Channel clientChannel, Object message) throws TimeoutException {
        return this.sendSyncRequest(clientChannel, message, NettyServerConfig.getRpcRequestTimeout());
    }

    @Override
    public Object sendSyncRequest(Channel clientChannel, Object message, long timeout) throws TimeoutException {
        if (clientChannel == null) {
            throw new RuntimeException("rm client is not connected");
        }
        return this.sendAsyncRequestWithResponse(null, clientChannel, message, timeout);
    }

    @Override
    public Object sendSyncRequest(String resourceId, String clientId, Object message) throws TimeoutException {
        return this.sendSyncRequest(resourceId, clientId, message, NettyServerConfig.getRpcRequestTimeout());
    }

    @Override
    public Object sendASyncRequest(Channel channel, Object message) throws TimeoutException {
        return this.sendAsyncRequestWithoutResponse(channel, message);
    }
}

