/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.loader;

import io.seata.common.Constants;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.EnhancedServiceNotFoundException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnhancedServiceLoader.class);
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static final String SEATA_DIRECTORY = "META-INF/seata/";
    private static Map<Class, List<Class>> providers = new ConcurrentHashMap<Class, List<Class>>();

    public static <S> S load(Class<S> service, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, null, loader);
    }

    public static <S> S load(Class<S> service) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, null, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, loader);
    }

    public static <S> S load(Class<S> service, String activateName, Object[] args) throws EnhancedServiceNotFoundException {
        Class[] argsType = null;
        if (args != null && args.length > 0) {
            argsType = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsType[i] = args[i].getClass();
            }
        }
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader(), argsType, args);
    }

    public static <S> S load(Class<S> service, String activateName, Class[] argsType, Object[] args) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader(), argsType, args);
    }

    public static <S> List<S> loadAll(Class<S> service) {
        return EnhancedServiceLoader.loadAll(service, null, null);
    }

    public static <S> List<S> loadAll(Class<S> service, Class[] argsType, Object[] args) {
        ArrayList<S> allInstances = new ArrayList<S>();
        List<Class> allClazzs = EnhancedServiceLoader.getAllExtensionClass(service);
        if (CollectionUtils.isEmpty(allClazzs)) {
            return allInstances;
        }
        try {
            for (Class clazz : allClazzs) {
                allInstances.add(EnhancedServiceLoader.initInstance(service, clazz, argsType, args));
            }
        }
        catch (Throwable t) {
            throw new EnhancedServiceNotFoundException(t);
        }
        return allInstances;
    }

    static <S> List<Class> getAllExtensionClass(Class<S> service) {
        return EnhancedServiceLoader.findAllExtensionClass(service, null, EnhancedServiceLoader.findClassLoader());
    }

    static <S> List<Class> getAllExtensionClass(Class<S> service, ClassLoader loader) {
        return EnhancedServiceLoader.findAllExtensionClass(service, null, loader);
    }

    private static <S> S loadFile(Class<S> service, String activateName, ClassLoader loader) {
        return EnhancedServiceLoader.loadFile(service, activateName, loader, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> S loadFile(Class<S> service, String activateName, ClassLoader loader, Class[] argTypes, Object[] args) {
        try {
            boolean foundFromCache = true;
            List<Class> extensions = providers.get(service);
            if (extensions == null) {
                Class<S> clazz = service;
                synchronized (clazz) {
                    extensions = providers.get(service);
                    if (extensions == null) {
                        extensions = EnhancedServiceLoader.findAllExtensionClass(service, activateName, loader);
                        foundFromCache = false;
                        providers.put(service, extensions);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)activateName)) {
                EnhancedServiceLoader.loadFile(service, SEATA_DIRECTORY + activateName.toLowerCase() + "/", loader, extensions);
                ArrayList<Class> activateExtensions = new ArrayList<Class>();
                for (Class clz : extensions) {
                    LoadLevel activate = clz.getAnnotation(LoadLevel.class);
                    if (activate == null || !activateName.equalsIgnoreCase(activate.name())) continue;
                    activateExtensions.add(clz);
                }
                extensions = activateExtensions;
            }
            if (extensions.isEmpty()) {
                throw new EnhancedServiceNotFoundException("not found service provider for : " + service.getName() + "[" + activateName + "] and classloader : " + ObjectUtils.toString((Object)loader));
            }
            Class extension = extensions.get(extensions.size() - 1);
            S result = EnhancedServiceLoader.initInstance(service, extension, argTypes, args);
            if (!foundFromCache && LOGGER.isInfoEnabled()) {
                LOGGER.info("load " + service.getSimpleName() + "[" + activateName + "] extension by class[" + extension.getName() + "]");
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof EnhancedServiceNotFoundException) {
                throw (EnhancedServiceNotFoundException)((Object)e);
            }
            throw new EnhancedServiceNotFoundException("not found service provider for : " + service.getName() + " caused by " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private static <S> List<Class> findAllExtensionClass(Class<S> service, String activateName, ClassLoader loader) {
        ArrayList<Class> extensions = new ArrayList<Class>();
        try {
            EnhancedServiceLoader.loadFile(service, SERVICES_DIRECTORY, loader, extensions);
            EnhancedServiceLoader.loadFile(service, SEATA_DIRECTORY, loader, extensions);
        }
        catch (IOException e) {
            throw new EnhancedServiceNotFoundException(e);
        }
        if (extensions.isEmpty()) {
            return extensions;
        }
        extensions.sort((c1, c2) -> {
            int o1 = 0;
            int o2 = 0;
            LoadLevel a1 = c1.getAnnotation(LoadLevel.class);
            LoadLevel a2 = c2.getAnnotation(LoadLevel.class);
            if (a1 != null) {
                o1 = a1.order();
            }
            if (a2 != null) {
                o2 = a2.order();
            }
            return Integer.compare(o1, o2);
        });
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFile(Class<?> service, String dir, ClassLoader classLoader, List<Class> extensions) throws IOException {
        String fileName = dir + service.getName();
        Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(url.openStream(), Constants.DEFAULT_CHARSET));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        try {
                            extensions.add(Class.forName(line, true, classLoader));
                        }
                        catch (ClassNotFoundException | LinkageError e) {
                            LOGGER.warn("load [{}] class fail. {}", (Object)line, (Object)e.getMessage());
                        }
                    }
                }
                catch (Throwable e) {
                    try {
                        LOGGER.warn(e.getMessage());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtil.close(reader);
                        continue;
                    }
                }
                IOUtil.close((AutoCloseable)reader);
            }
        }
    }

    protected static <S> S initInstance(Class<S> service, Class implClazz, Class[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        S s = null;
        if (argTypes != null && args != null) {
            Constructor constructor = implClazz.getDeclaredConstructor(argTypes);
            s = service.cast(constructor.newInstance(args));
        } else {
            s = service.cast(implClazz.newInstance());
        }
        if (s instanceof Initialize) {
            ((Initialize)s).init();
        }
        return s;
    }

    private static ClassLoader findClassLoader() {
        return EnhancedServiceLoader.class.getClassLoader();
    }
}

