/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.utils;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.util.StringUtils;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.utils.ExceptionUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

public class CompensationHolder {
    private Map<String, StateInstance> statesNeedCompensation = new ConcurrentHashMap<String, StateInstance>();
    private Map<String, StateInstance> statesForCompensation = new ConcurrentHashMap<String, StateInstance>();
    private Stack<StateInstance> stateStackNeedCompensation = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompensationHolder getCurrent(ProcessContext context, boolean forceCreate) {
        CompensationHolder compensationholder = (CompensationHolder)context.getVariable("_current_compensation_holder_");
        if (compensationholder == null && forceCreate) {
            ProcessContext processContext = context;
            synchronized (processContext) {
                compensationholder = (CompensationHolder)context.getVariable("_current_compensation_holder_");
                if (compensationholder == null) {
                    compensationholder = new CompensationHolder();
                    context.setVariable("_current_compensation_holder_", compensationholder);
                }
            }
        }
        return compensationholder;
    }

    public static List<StateInstance> findStateInstListToBeCompensated(ProcessContext context, List<StateInstance> stateInstanceList) {
        ArrayList<StateInstance> stateListToBeCompensated = null;
        if (stateInstanceList != null && stateInstanceList.size() > 0) {
            stateListToBeCompensated = new ArrayList<StateInstance>(stateInstanceList.size());
            StateMachine stateMachine = (StateMachine)context.getVariable("_current_statemachine_");
            StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
            for (StateInstance stateInstance : stateInstanceList) {
                if (!CompensationHolder.stateNeedToCompensate(stateInstance)) continue;
                State state = stateMachine.getState(stateInstance.getName());
                AbstractTaskState taskState = null;
                if (state instanceof AbstractTaskState) {
                    taskState = (AbstractTaskState)state;
                }
                if (stateInstance.isForUpdate() && taskState != null && StringUtils.isBlank(taskState.getCompensateState())) {
                    String message = "StateMachineInstance[" + stateMachineInstance.getId() + ":" + stateMachine.getName() + "] have a state [" + stateInstance.getName() + "] is a service for update data\uff0cbut no compensateState found.";
                    EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(FrameworkErrorCode.CompensationStateNotFound, message, stateMachineInstance, stateInstance);
                    EngineUtils.failStateMachine(context, exception);
                    throw exception;
                }
                if (taskState == null || !StringUtils.isNotBlank(taskState.getCompensateState())) continue;
                stateListToBeCompensated.add(stateInstance);
            }
        }
        return stateListToBeCompensated;
    }

    private static boolean stateNeedToCompensate(StateInstance stateInstance) {
        if (stateInstance.isIgnoreStatus()) {
            return false;
        }
        if ("SubStateMachine".equals(stateInstance.getType())) {
            return !ExecutionStatus.FA.equals((Object)stateInstance.getStatus()) && !ExecutionStatus.SU.equals((Object)stateInstance.getCompensationStatus());
        }
        return "ServiceTask".equals(stateInstance.getType()) && !stateInstance.isForCompensation() && !ExecutionStatus.FA.equals((Object)stateInstance.getStatus()) && !ExecutionStatus.SU.equals((Object)stateInstance.getCompensationStatus());
    }

    public static void clearCurrent(ProcessContext context) {
        context.removeVariable("_current_compensation_holder_");
    }

    public Map<String, StateInstance> getStatesNeedCompensation() {
        return this.statesNeedCompensation;
    }

    public void addToBeCompensatedState(String stateName, StateInstance toBeCompensatedState) {
        this.statesNeedCompensation.put(stateName, toBeCompensatedState);
    }

    public Map<String, StateInstance> getStatesForCompensation() {
        return this.statesForCompensation;
    }

    public void addForCompensationState(String stateName, StateInstance forCompensationState) {
        this.statesForCompensation.put(stateName, forCompensationState);
    }

    public Stack<StateInstance> getStateStackNeedCompensation() {
        return this.stateStackNeedCompensation;
    }
}

