/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.oracle.keyword;

import io.seata.rm.datasource.undo.KeywordChecker;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class OracleKeywordChecker
implements KeywordChecker {
    private static volatile KeywordChecker keywordChecker = null;
    private Set<String> keywordSet = Arrays.stream(OracleKeyword.values()).map(Enum::name).collect(Collectors.toSet());

    private OracleKeywordChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeywordChecker getInstance() {
        if (keywordChecker != null) return keywordChecker;
        Class<OracleKeywordChecker> clazz = OracleKeywordChecker.class;
        synchronized (OracleKeywordChecker.class) {
            if (keywordChecker != null) return keywordChecker;
            keywordChecker = new OracleKeywordChecker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return keywordChecker;
        }
    }

    @Override
    public boolean check(String fieldOrTableName) {
        if (this.keywordSet.contains(fieldOrTableName)) {
            return true;
        }
        if (null != fieldOrTableName) {
            fieldOrTableName = fieldOrTableName.toUpperCase();
        }
        return this.keywordSet.contains(fieldOrTableName);
    }

    @Override
    public String checkAndReplace(String fieldOrTableName) {
        return this.check(fieldOrTableName) ? fieldOrTableName : fieldOrTableName;
    }

    private static enum OracleKeyword {
        ACCESS("ACCESS"),
        ADD("ADD"),
        ALL("ALL"),
        ALTER("ALTER"),
        AND("AND"),
        ANY("ANY"),
        AS("AS"),
        ASC("ASC"),
        AUDIT("AUDIT"),
        BETWEEN("BETWEEN"),
        BY("BY"),
        CHAR("CHAR"),
        CHECK("CHECK"),
        CLUSTER("CLUSTER"),
        COLUMN("COLUMN"),
        COLUMN_VALUE("COLUMN_VALUE"),
        COMMENT("COMMENT"),
        COMPRESS("COMPRESS"),
        CONNECT("CONNECT"),
        CREATE("CREATE"),
        CURRENT("CURRENT"),
        DATE("DATE"),
        DECIMAL("DECIMAL"),
        DEFAULT("DEFAULT"),
        DELETE("DELETE"),
        DESC("DESC"),
        DISTINCT("DISTINCT"),
        DROP("DROP"),
        ELSE("ELSE"),
        EXCLUSIVE("EXCLUSIVE"),
        EXISTS("EXISTS"),
        FILE("FILE"),
        FLOAT("FLOAT"),
        FOR("FOR"),
        FROM("FROM"),
        GRANT("GRANT"),
        GROUP("GROUP"),
        HAVING("HAVING"),
        IDENTIFIED("IDENTIFIED"),
        IMMEDIATE("IMMEDIATE"),
        IN("IN"),
        INCREMENT("INCREMENT"),
        INDEX("INDEX"),
        INITIAL("INITIAL"),
        INSERT("INSERT"),
        INTEGER("INTEGER"),
        INTERSECT("INTERSECT"),
        INTO("INTO"),
        IS("IS"),
        LEVEL("LEVEL"),
        LIKE("LIKE"),
        LOCK("LOCK"),
        LONG("LONG"),
        MAXEXTENTS("MAXEXTENTS"),
        MINUS("MINUS"),
        MLSLABEL("MLSLABEL"),
        MODE("MODE"),
        MODIFY("MODIFY"),
        NESTED_TABLE_ID("NESTED_TABLE_ID"),
        NOAUDIT("NOAUDIT"),
        NOCOMPRESS("NOCOMPRESS"),
        NOT("NOT"),
        NOWAIT("NOWAIT"),
        NULL("NULL"),
        NUMBER("NUMBER"),
        OF("OF"),
        OFFLINE("OFFLINE"),
        ON("ON"),
        ONLINE("ONLINE"),
        OPTION("OPTION"),
        OR("OR"),
        ORDER("ORDER"),
        PCTFREE("PCTFREE"),
        PRIOR("PRIOR"),
        PUBLIC("PUBLIC"),
        RAW("RAW"),
        RENAME("RENAME"),
        RESOURCE("RESOURCE"),
        REVOKE("REVOKE"),
        ROW("ROW"),
        ROWID("ROWID"),
        ROWNUM("ROWNUM"),
        ROWS("ROWS"),
        SELECT("SELECT"),
        SESSION("SESSION"),
        SET("SET"),
        SHARE("SHARE"),
        SIZE("SIZE"),
        SMALLINT("SMALLINT"),
        START("START"),
        SUCCESSFUL("SUCCESSFUL"),
        SYNONYM("SYNONYM"),
        SYSDATE("SYSDATE"),
        TABLE("TABLE"),
        THEN("THEN"),
        TO("TO"),
        TRIGGER("TRIGGER"),
        UID("UID"),
        UNION("UNION"),
        UNIQUE("UNIQUE"),
        UPDATE("UPDATE"),
        USER("USER"),
        VALIDATE("VALIDATE"),
        VALUES("VALUES"),
        VARCHAR("VARCHAR"),
        VARCHAR2("VARCHAR2"),
        VIEW("VIEW"),
        WHENEVER("WHENEVER"),
        WHERE("WHERE"),
        WITH("WITH");

        public final String name;

        private OracleKeyword(String name) {
            this.name = name;
        }
    }
}

