/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.mysql;

import io.seata.common.util.BlobUtils;
import io.seata.rm.datasource.undo.AbstractUndoLogManager;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLUndoLogManager
extends AbstractUndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLUndoLogManager.class);
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + " (" + "branch_id" + ", " + "xid" + ", " + "context" + ", " + "rollback_info" + ", " + "log_status" + ", " + "log_created" + ", " + "log_modified" + ") VALUES (?, ?, ?, ?, ?, now(), now())";
    private static final String DELETE_UNDO_LOG_BY_CREATE_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE log_created <= ? LIMIT ?";

    @Override
    public String getDbType() {
        return "mysql";
    }

    @Override
    public int deleteUndoLogByLogCreated(Date logCreated, int limitRows, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = null;){
            deletePST = conn.prepareStatement(DELETE_UNDO_LOG_BY_CREATE_SQL);
            deletePST.setDate(1, new java.sql.Date(logCreated.getTime()));
            deletePST.setInt(2, limitRows);
            int deleteRows = deletePST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete undo log size " + deleteRows);
            }
            int n = deleteRows;
            return n;
        }
    }

    @Override
    protected void insertUndoLogWithNormal(String xid, long branchID, String rollbackCtx, byte[] undoLogContent, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchID, rollbackCtx, undoLogContent, AbstractUndoLogManager.State.Normal, conn);
    }

    @Override
    protected void insertUndoLogWithGlobalFinished(String xid, long branchID, UndoLogParser parser, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchID, this.buildContext(parser.getName()), parser.getDefaultContent(), AbstractUndoLogManager.State.GlobalFinished, conn);
    }

    private void insertUndoLog(String xid, long branchID, String rollbackCtx, byte[] undoLogContent, AbstractUndoLogManager.State state, Connection conn) throws SQLException {
        try (PreparedStatement pst = null;){
            pst = conn.prepareStatement(INSERT_UNDO_LOG_SQL);
            pst.setLong(1, branchID);
            pst.setString(2, xid);
            pst.setString(3, rollbackCtx);
            pst.setBlob(4, BlobUtils.bytes2Blob(undoLogContent));
            pst.setInt(5, state.getValue());
            pst.executeUpdate();
        }
    }
}

