/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public final class RejectedPolicies {
    public static RejectedExecutionHandler runsOldestTaskPolicy() {
        return new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (executor.isShutdown()) {
                    return;
                }
                BlockingQueue<Runnable> workQueue = executor.getQueue();
                Runnable firstWork = (Runnable)workQueue.poll();
                boolean newTaskAdd = workQueue.offer(r);
                if (firstWork != null) {
                    firstWork.run();
                }
                if (!newTaskAdd) {
                    executor.execute(r);
                }
            }
        };
    }
}

