/*
 * Decompiled with CFR 0.152.
 */
package io.rhiot.utils.process;

import io.rhiot.utils.process.CollectingLogOutputStream;
import io.rhiot.utils.process.ProcessManager;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecProcessManager
implements ProcessManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExecProcessManager.class);
    private int timeout;

    public ExecProcessManager() {
    }

    public ExecProcessManager(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public List<String> executeAndJoinOutput(String ... command) {
        CommandLine cmdLine = CommandLine.parse((String)String.join((CharSequence)" ", command));
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        ExecResultHandler resultHandler = null;
        if (this.getTimeout() > 0) {
            ExecuteWatchdog watchdog = new ExecuteWatchdog((long)this.getTimeout());
            executor.setWatchdog(watchdog);
            resultHandler = new ExecResultHandler(watchdog);
        }
        try {
            CollectingLogOutputStream outAndErr = new CollectingLogOutputStream();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)outAndErr)));
            if (resultHandler != null) {
                executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
            } else {
                executor.execute(cmdLine);
            }
            resultHandler.waitFor();
            return outAndErr.getLines();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private class ExecResultHandler
    extends DefaultExecuteResultHandler {
        private ExecuteWatchdog watchdog;

        public ExecResultHandler(ExecuteWatchdog watchdog) {
            this.watchdog = watchdog;
        }

        public ExecResultHandler(int exitValue) {
            LOG.debug("Installation completed with exitValue [{}]", (Object)exitValue);
            super.onProcessComplete(exitValue);
        }

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            LOG.debug("Successfully installed");
        }

        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            if (this.watchdog != null && this.watchdog.killedProcess()) {
                LOG.warn("Installation killed by watchdog");
            } else {
                LOG.warn("Installation failed due to [{}]", (Object)e.getMessage());
            }
        }
    }
}

