/*
 * Decompiled with CFR 0.152.
 */
package io.rhiot.utils.install;

import io.rhiot.utils.OsUtils;
import io.rhiot.utils.install.Installer;
import io.rhiot.utils.install.exception.PermissionDeniedException;
import io.rhiot.utils.process.ExecProcessManager;
import io.rhiot.utils.process.ProcessManager;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstaller
implements Installer {
    public static final String DEFAULT_INSTALL_COMMAND = "apt-get -q -y install";
    public static final String DEFAULT_UNINSTALL_COMMAND = "apt-get -q -y remove";
    public static final String DEFAULT_IS_INSTALLED_COMMAND = "dpkg -s";
    public static final String DEFAULT_INSTALL_SUCCESS = "Status: install ok installed";
    public static final String DEFAULT_COMMAND_NOT_FOUND_MESSAGE = "command not found";
    public static final String PERMISSION_DENIED_MESSAGE = "Permission denied";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInstaller.class);
    public static final int DEFAULT_TIMEOUT = 600000;
    private int timeout = 600000;
    private String installCommand = "apt-get -q -y install";
    private String uninstallCommand = "apt-get -q -y remove";
    private String isInstalledCommand = "dpkg -s";
    private String installSuccess = "Status: install ok installed";
    private ProcessManager processManager = new ExecProcessManager(this.getTimeout());

    public DefaultInstaller() {
    }

    public DefaultInstaller(String installCommand, String uninstallCommand, String isInstalledCommand) {
        this.installCommand = installCommand;
        this.uninstallCommand = uninstallCommand;
        this.isInstalledCommand = isInstalledCommand;
    }

    public DefaultInstaller(String installCommand, String uninstallCommand, String isInstalledCommand, String installSuccess) {
        this.installCommand = installCommand;
        this.uninstallCommand = uninstallCommand;
        this.isInstalledCommand = isInstalledCommand;
        this.installSuccess = installSuccess;
    }

    public boolean isCommandInstalled(String command, String failureMessage) {
        List<String> output = this.getProcessManager().executeAndJoinOutput(command);
        return output.size() > 0 && !output.get(0).contains(failureMessage);
    }

    public boolean isCommandInstalled(String command) {
        return this.isCommandInstalled(command, DEFAULT_COMMAND_NOT_FOUND_MESSAGE);
    }

    @Override
    public boolean isInstalled(List<String> packages) {
        if (packages == null || packages.size() == 0) {
            return true;
        }
        return !packages.stream().anyMatch(s -> !this.isInstalled((String)s));
    }

    @Override
    public boolean isInstalled(String packageName) {
        if (!this.isPlatformSupported()) {
            throw new UnsupportedOperationException("DefaultInstaller does not support this platform");
        }
        boolean installed = this.confirmInstalled(packageName, this.getProcessManager().executeAndJoinOutput((String.valueOf(this.getIsInstalledCommand()) + " " + packageName).split(" ")));
        LOG.info("[{}] isInstalled ? {} ", (Object)packageName, (Object)installed);
        return installed;
    }

    public boolean confirmInstalled(String packageName, List<String> output) {
        if (output != null) {
            return output.stream().anyMatch(s -> s != null && s.contains(this.getInstallSuccess()));
        }
        return true;
    }

    @Override
    public boolean install(String packageNames) {
        if (!this.isPlatformSupported()) {
            throw new UnsupportedOperationException("DefaultInstaller does not support this platform");
        }
        if (StringUtils.isEmpty((CharSequence)packageNames)) {
            return true;
        }
        LOG.info("Installing [{}]", (Object)packageNames);
        String normalizedNames = packageNames.replaceAll(",", " ");
        if (this.isInstalled(Arrays.asList(normalizedNames.split(" ")))) {
            LOG.info("Already installed");
            return true;
        }
        List<String> output = this.getProcessManager().executeAndJoinOutput(String.join((CharSequence)" ", (String.valueOf(this.getInstallCommand()) + " " + normalizedNames).split(" ")));
        LOG.info("Installation result : {}", output);
        if (this.isPermissionDenied(output)) {
            throw new PermissionDeniedException("You must have sufficient privileges to install package/s [" + packageNames + "]");
        }
        return this.isInstalled(Arrays.asList(normalizedNames.split(" ")));
    }

    @Override
    public void uninstall(String packageNames) {
        if (!this.isPlatformSupported()) {
            throw new UnsupportedOperationException("DefaultInstaller does not support this platform");
        }
        LOG.info("Uninstalling [{}]", (Object)packageNames);
        List<String> output = this.getProcessManager().executeAndJoinOutput((String.valueOf(this.getUninstallCommand()) + " " + packageNames.replaceAll(",", " ")).split(" "));
        LOG.info("Uninstall result : {}", output);
        if (this.isPermissionDenied(output)) {
            throw new PermissionDeniedException("You must have sufficient privileges to uninstall package/s [" + packageNames + "]");
        }
    }

    protected boolean isPermissionDenied(List<String> output) {
        return output.stream().anyMatch(s -> s != null && s.contains(PERMISSION_DENIED_MESSAGE));
    }

    public boolean isPlatformSupported() {
        return OsUtils.isLinux();
    }

    public String getInstallCommand() {
        return this.installCommand;
    }

    public void setInstallCommand(String installCommand) {
        this.installCommand = installCommand;
    }

    public String getUninstallCommand() {
        return this.uninstallCommand;
    }

    public void setUninstallCommand(String uninstallCommand) {
        this.uninstallCommand = uninstallCommand;
    }

    public String getIsInstalledCommand() {
        return this.isInstalledCommand;
    }

    public void setIsInstalledCommand(String isInstalledCommand) {
        this.isInstalledCommand = isInstalledCommand;
    }

    public String getInstallSuccess() {
        return this.installSuccess;
    }

    public void setInstallSuccess(String installSuccess) {
        this.installSuccess = installSuccess;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

