/*
 * Decompiled with CFR 0.152.
 */
package io.rhiot.utils.geo;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Geos {
    private static final Logger LOG = LoggerFactory.getLogger(Geos.class);

    private Geos() {
    }

    public static double convertDdmCoordinatesToDecimal(String ddmCoordinate) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ddmCoordinate), (Object)"Coordinate to convert can't be null nor blank.");
        int dotIndex = ddmCoordinate.indexOf(46);
        double degrees = Double.parseDouble(ddmCoordinate.substring(0, dotIndex - 2));
        double minutes = Double.parseDouble(ddmCoordinate.substring(dotIndex - 2));
        double decimalCoordinates = degrees + minutes / 60.0;
        LOG.debug("Converted NMEA DDM degree coordinate {} (degrees/minutes: {}/{}) to decimal coordinate {}.", new Object[]{ddmCoordinate, degrees, minutes, decimalCoordinates});
        return decimalCoordinates;
    }
}

