/*
 * Decompiled with CFR 0.152.
 */
package io.rhiot.utils;

import io.rhiot.utils.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class Reflections {
    private static final Map<Class<?>, Class<?>> wrapperClasses = Maps.immutableMapOf(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Float.TYPE, Float.class, Double.TYPE, Double.class);

    private Reflections() {
    }

    public static <T> Class<T[]> classOfArrayOfClass(Class<T> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    public static void writeField(Object object, String field, Object value) {
        try {
            FieldUtils.writeField((Object)object, (String)field, (Object)value, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readField(Object object, String field, Class<T> type) {
        try {
            Field actualField = FieldUtils.getField(object.getClass(), (String)field, (boolean)true);
            if (!Reflections.isInstanceOfOrWrappable(actualField.getType(), type)) {
                String message = String.format("Field %s is a type of %s instead of %s.", field, actualField.getType(), type);
                throw new IllegalStateException(message);
            }
            return (T)FieldUtils.readField((Field)actualField, (Object)object, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void runMain(Class<?> classWithMain, String ... args) {
        try {
            Method mainMethod = classWithMain.getMethod("main", String[].class);
            if (mainMethod == null) {
                throw new IllegalArgumentException("No main method in class " + classWithMain.getName());
            }
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isInstanceOfOrWrappable(Class<?> type, Class<?> instanceOf) {
        if (instanceOf.isAssignableFrom(type)) {
            return true;
        }
        type = wrapperClasses.get(type);
        return instanceOf.isAssignableFrom(type);
    }

    public static String classNameToCamelCase(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return String.valueOf(Character.toLowerCase(simpleName.charAt(0))) + simpleName.substring(1);
    }

    public static boolean isNumber(Class<?> type) {
        return wrapperClasses.containsKey(type) || wrapperClasses.containsValue(type);
    }

    public static boolean isJavaLibraryType(Class<?> type) {
        return Reflections.isNumber(type) || type == String.class || type == Date.class;
    }
}

