/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractJsonCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.nio.ByteBuffer;

final class JsonByteBufferCodec
extends AbstractJsonCodec<ByteBuffer> {
    private final ByteBufAllocator byteBufAllocator;

    JsonByteBufferCodec(ByteBufAllocator byteBufAllocator) {
        super(ByteBuffer.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    ByteBuffer doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends ByteBuffer> type) {
        ByteBuffer result = ByteBuffer.allocate(buffer.readableBytes());
        buffer.readBytes(result);
        result.flip();
        return result;
    }

    @Override
    Parameter doEncode(ByteBuffer value) {
        Assert.requireNonNull(value, "value must not be null");
        return JsonByteBufferCodec.create(PostgresqlObjectId.JSON, Format.FORMAT_TEXT, () -> this.byteBufAllocator.buffer(value.remaining()).writeBytes(value));
    }
}

