/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collections;
import java.util.function.Supplier;

final class BooleanArrayCodec
extends AbstractArrayCodec<Boolean> {
    BooleanArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Boolean.class);
    }

    @Override
    public Parameter encodeNull() {
        return BooleanArrayCodec.createNull(PostgresqlObjectId.BOOL_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return Collections.singleton(PostgresqlObjectId.BOOL_ARRAY);
    }

    @Override
    Boolean doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readBoolean();
    }

    @Override
    Boolean doDecodeText(String text) {
        return "1".equals(text) || "true".equalsIgnoreCase(text) || "t".equalsIgnoreCase(text) || "yes".equalsIgnoreCase(text) || "y".equalsIgnoreCase(text) || "on".equalsIgnoreCase(text);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BOOL_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return BooleanArrayCodec.create(PostgresqlObjectId.BOOL_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(Boolean value) {
        Assert.requireNonNull(value, "value must not be null");
        return value != false ? "TRUE" : "FALSE";
    }
}

