/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import reactor.util.annotation.Nullable;

public class BigIntegerCodec
extends AbstractNumericCodec<BigInteger> {
    private final ByteBufAllocator byteBufAllocator;

    public BigIntegerCodec(ByteBufAllocator byteBufAllocator) {
        super(BigInteger.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return BigIntegerCodec.createNull(PostgresqlObjectId.NUMERIC, Format.FORMAT_TEXT);
    }

    @Override
    BigInteger doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends BigInteger> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeNumber(buffer, dataType, format, BigInteger.class, it -> it instanceof BigDecimal ? ((BigDecimal)it).toBigInteger() : BigInteger.valueOf(it.longValue()));
    }

    @Override
    Parameter doEncode(BigInteger value) {
        Assert.requireNonNull(value, "value must not be null");
        return BigIntegerCodec.create(PostgresqlObjectId.NUMERIC, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.NUMERIC;
    }
}

