/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.codec.Decoder;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ArrayCodec {
    static final byte COMMA = 44;

    ArrayCodec() {
    }

    private static int getDimensions(List<?> list) {
        int dims = 1;
        Object inner = list.get(0);
        while (inner instanceof List) {
            inner = ((List)inner).get(0);
            ++dims;
        }
        return dims;
    }

    static <T> T[] decodeBinary(ByteBuf buffer, int dataType, Decoder<T> decoder, Class<T> componentType, Class<?> returnType) {
        if (!buffer.isReadable()) {
            return (Object[])Array.newInstance(componentType, 0);
        }
        int dimensions = buffer.readInt();
        if (dimensions == 0) {
            return (Object[])Array.newInstance(componentType, 0);
        }
        if (returnType != Object.class) {
            Assert.requireArrayDimension(returnType, dimensions, "Dimensions mismatch: %s expected, but %s returned from DB");
        }
        buffer.skipBytes(4);
        buffer.skipBytes(4);
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = buffer.readInt();
            buffer.skipBytes(4);
        }
        Object[] array = (Object[])Array.newInstance(componentType, dims);
        ArrayCodec.readArrayAsBinary(buffer, dataType, array, dims, decoder, componentType, 0);
        return array;
    }

    static <T> T[] decodeText(ByteBuf buffer, int dataType, byte delimiter, Decoder<T> decoder, Class<T> componentType, Class<?> returnType) {
        List<Object> elements = ArrayCodec.decodeText(buffer, delimiter, dataType, decoder, componentType);
        if (elements.isEmpty()) {
            return (Object[])Array.newInstance(componentType, 0);
        }
        int dimensions = ArrayCodec.getDimensions(elements);
        if (returnType != Object.class) {
            Assert.requireArrayDimension(returnType, dimensions, "Dimensions mismatch: %s expected, but %s returned from DB");
        }
        return ArrayCodec.toArray(elements, ArrayCodec.createArrayType(componentType, dimensions).getComponentType());
    }

    private static <T> Class<T> createArrayType(Class<T> componentType, int dims) {
        int[] size = new int[dims];
        Arrays.fill(size, 1);
        return Array.newInstance(componentType, size).getClass();
    }

    private static <T> T[] toArray(List<T> list, Class<T> returnType) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (T e : list) {
            T o = e instanceof List ? ArrayCodec.toArray((List)e, returnType.getComponentType()) : e;
            result.add(o);
        }
        return result.toArray((Object[])Array.newInstance(returnType, list.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<Object> decodeText(ByteBuf buf, byte delimiter, int dataType, Decoder<T> decoder, Class<T> componentType) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean insideString = false;
        boolean wasInsideString = false;
        ArrayList dims = new ArrayList();
        List<Object> currentArray = arrayList;
        if (buf.isReadable() && buf.getByte(0) == 91) {
            while (buf.readByte() != 61) {
            }
        }
        int indentEscape = 0;
        int readFrom = 0;
        boolean requiresEscapeCharFiltering = false;
        while (buf.isReadable()) {
            byte currentChar = buf.readByte();
            if (currentChar == 92) {
                ++indentEscape;
                buf.skipBytes(1);
                requiresEscapeCharFiltering = true;
                continue;
            }
            if (!insideString && currentChar == 123) {
                if (dims.isEmpty()) {
                    dims.add(arrayList);
                } else {
                    ArrayList a = new ArrayList();
                    List p = (List)dims.get(dims.size() - 1);
                    p.add(a);
                    dims.add(a);
                }
                currentArray = (List)dims.get(dims.size() - 1);
                for (int t = indentEscape + 1; t < buf.writerIndex() && (Character.isWhitespace(buf.getByte(t)) || buf.getByte(t) == 123); ++t) {
                }
                readFrom = buf.readerIndex();
                continue;
            }
            if (currentChar == 34) {
                insideString = !insideString;
                wasInsideString = true;
                continue;
            }
            if (!insideString && Character.isWhitespace(currentChar) || (insideString || currentChar != delimiter && currentChar != 125) && indentEscape != buf.writerIndex() - 1) continue;
            int skipTrailingBytes = 0;
            if (currentChar != 125 && currentChar != delimiter && readFrom > 0) {
                ++skipTrailingBytes;
            }
            if (wasInsideString) {
                ++readFrom;
                ++skipTrailingBytes;
            }
            ByteBuf slice = buf.slice(readFrom, buf.readerIndex() - readFrom - (skipTrailingBytes + 1));
            try {
                if (requiresEscapeCharFiltering) {
                    ByteBuf filtered = slice.alloc().buffer(slice.readableBytes());
                    while (slice.isReadable()) {
                        byte ch = slice.readByte();
                        if (ch == 92) {
                            ch = slice.readByte();
                        }
                        filtered.writeByte((int)ch);
                    }
                    slice = filtered;
                }
                if (slice.isReadable() || wasInsideString) {
                    if (!wasInsideString && slice.readableBytes() == 4 && slice.getByte(0) == 78 && "NULL".equals(slice.toString(StandardCharsets.US_ASCII))) {
                        currentArray.add(null);
                    } else {
                        currentArray.add(decoder.decode(slice, dataType, Format.FORMAT_TEXT, componentType));
                    }
                }
            }
            finally {
                if (requiresEscapeCharFiltering) {
                    slice.release();
                }
            }
            wasInsideString = false;
            requiresEscapeCharFiltering = false;
            readFrom = buf.readerIndex();
            if (currentChar != 125) continue;
            dims.remove(dims.size() - 1);
            if (dims.isEmpty()) continue;
            currentArray = (List)dims.get(dims.size() - 1);
        }
        return arrayList;
    }

    private static <T> void readArrayAsBinary(ByteBuf buffer, int dataType, Object[] array, int[] dims, Decoder<T> decoder, Class<T> componentType, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = buffer.readInt();
                if (len == -1) continue;
                array[i] = decoder.decode(buffer.readSlice(len), dataType, Format.FORMAT_BINARY, componentType);
            }
        } else {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                ArrayCodec.readArrayAsBinary(buffer, dataType, (Object[])array[i], dims, decoder, componentType, thisDimension + 1);
            }
        }
    }
}

