/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import org.apache.maven.model.building.ModelCache;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;

class BootstrapModelCache
implements ModelCache {
    private final RepositorySystemSession session;
    private final RepositoryCache cache;

    BootstrapModelCache(RepositorySystemSession session) {
        this.session = session;
        this.cache = session.getCache() == null ? new DefaultRepositoryCache() : session.getCache();
    }

    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.cache.get(this.session, (Object)new Key(groupId, artifactId, version, tag));
    }

    public void put(String groupId, String artifactId, String version, String tag, Object data) {
        this.cache.put(this.session, (Object)new Key(groupId, artifactId, version, tag), data);
    }

    static class Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String tag;
        private final int hash;

        public Key(String groupId, String artifactId, String version, String tag) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.tag = tag;
            int h = 17;
            h = h * 31 + this.groupId.hashCode();
            h = h * 31 + this.artifactId.hashCode();
            h = h * 31 + this.version.hashCode();
            this.hash = h = h * 31 + this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

