/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;

public class LocalWorkspace
implements WorkspaceModelResolver,
WorkspaceReader {
    private final Map<AppArtifactKey, LocalProject> projects = new HashMap<AppArtifactKey, LocalProject>();
    private final WorkspaceRepository wsRepo = new WorkspaceRepository();
    private AppArtifactKey lastFindVersionsKey;
    private List<String> lastFindVersions;
    private long lastModified;
    private int id = 1;
    private String resolvedVersion;

    protected void addProject(LocalProject project, long lastModified) {
        this.projects.put(project.getKey(), project);
        if (lastModified > this.lastModified) {
            this.lastModified = lastModified;
        }
        this.id = 31 * this.id + (int)(lastModified ^ lastModified >>> 32);
    }

    public LocalProject getProject(String groupId, String artifactId) {
        return this.getProject(new AppArtifactKey(groupId, artifactId));
    }

    public LocalProject getProject(AppArtifactKey key) {
        return this.projects.get(key);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getId() {
        return this.id;
    }

    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        LocalProject project = this.getProject(groupId, artifactId);
        if (project == null || !project.getVersion().equals(versionConstraint)) {
            return null;
        }
        return project.getRawModel();
    }

    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        return null;
    }

    public Map<AppArtifactKey, LocalProject> getProjects() {
        return this.projects;
    }

    public WorkspaceRepository getRepository() {
        return this.wsRepo;
    }

    public File findArtifact(Artifact artifact) {
        Path path;
        LocalProject lp = this.getProject(artifact.getGroupId(), artifact.getArtifactId());
        if (!(lp != null && (lp.getVersion().equals(artifact.getVersion()) || LocalProject.isUnresolvedVersion(artifact.getVersion()) && lp.getVersion().equals(this.resolvedVersion)))) {
            return null;
        }
        if (!Objects.equals(artifact.getClassifier(), lp.getAppArtifact().getClassifier())) {
            Path path2;
            if ("tests".equals(artifact.getClassifier()) && Files.exists(path2 = lp.getTestClassesDir(), new LinkOption[0])) {
                return path2.toFile();
            }
            return null;
        }
        String type = artifact.getExtension();
        if (type.equals("jar")) {
            Path path3 = lp.getClassesDir();
            if (Files.exists(path3, new LinkOption[0])) {
                return path3.toFile();
            }
            path3 = lp.getOutputDir().resolve(lp.getArtifactId() + "-" + lp.getVersion() + ".jar");
            if (Files.exists(path3, new LinkOption[0])) {
                return path3.toFile();
            }
        } else if (type.equals("pom") && Files.exists(path = lp.getDir().resolve("pom.xml"), new LinkOption[0])) {
            return path.toFile();
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        if (this.lastFindVersionsKey != null && artifact.getVersion().equals(this.lastFindVersions.get(0)) && this.lastFindVersionsKey.getArtifactId().equals(artifact.getArtifactId()) && this.lastFindVersionsKey.getGroupId().equals(artifact.getGroupId())) {
            return this.lastFindVersions;
        }
        this.lastFindVersionsKey = new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId());
        LocalProject lp = this.getProject(this.lastFindVersionsKey);
        if (lp == null || !lp.getVersion().equals(artifact.getVersion())) {
            this.lastFindVersionsKey = null;
            return Collections.emptyList();
        }
        this.lastFindVersions = Collections.singletonList(artifact.getVersion());
        return this.lastFindVersions;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    void setResolvedVersion(String resolvedVersion) {
        this.resolvedVersion = resolvedVersion;
    }
}

