/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class QuarkusClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(QuarkusClassLoader.class);
    protected static final String META_INF_SERVICES = "META-INF/services/";
    protected static final String JAVA = "java.";
    private final String name;
    private final List<ClassPathElement> elements;
    private final ConcurrentMap<ClassPathElement, ProtectionDomain> protectionDomains = new ConcurrentHashMap<ClassPathElement, ProtectionDomain>();
    private final ClassLoader parent;
    private final boolean parentFirst;
    private final boolean aggregateParentResources;
    private final List<ClassPathElement> bannedElements;
    private final List<ClassPathElement> parentFirstElements;
    private final List<ClassPathElement> lesserPriorityElements;
    private volatile MemoryClassPathElement resettableElement;
    private volatile Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers;
    private volatile ClassLoader transformerClassLoader;
    private volatile ClassLoaderState state;

    private QuarkusClassLoader(Builder builder) {
        super(null);
        this.name = builder.name;
        this.elements = builder.elements;
        this.bytecodeTransformers = builder.bytecodeTransformers;
        this.bannedElements = builder.bannedElements;
        this.parentFirstElements = builder.parentFirstElements;
        this.lesserPriorityElements = builder.lesserPriorityElements;
        this.parent = builder.parent;
        this.parentFirst = builder.parentFirst;
        this.resettableElement = builder.resettableElement;
        this.transformerClassLoader = builder.transformerClassLoader;
        this.aggregateParentResources = builder.aggregateParentResources;
    }

    public static Builder builder(String name, ClassLoader parent, boolean parentFirst) {
        return new Builder(name, parent, parentFirst);
    }

    private String sanitizeName(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private boolean parentFirst(String name, ClassLoaderState state) {
        return this.parentFirst || state.parentFirstResources.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Map<String, byte[]> resources, Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers, ClassLoader transformerClassLoader) {
        if (this.resettableElement == null) {
            throw new IllegalStateException("Classloader is no resettable");
        }
        this.transformerClassLoader = transformerClassLoader;
        QuarkusClassLoader quarkusClassLoader = this;
        synchronized (quarkusClassLoader) {
            this.resettableElement.reset(resources);
            this.bytecodeTransformers = bytecodeTransformers;
            this.state = null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String nm) throws IOException {
        ClassLoaderState state = this.getState();
        String name = this.sanitizeName(nm);
        boolean banned = state.bannedResources.contains(name);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        if (name.startsWith(META_INF_SERVICES)) {
            try {
                Class<?> c = this.loadClass(name.substring(META_INF_SERVICES.length()));
                if (c.getClassLoader() == this) {
                    banned = true;
                }
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
        }
        for (ClassPathElement i : this.elements) {
            ClassPathResource res = i.getResource(nm);
            if (res == null) continue;
            resources.add(res.getUrl());
        }
        if (!banned && (resources.isEmpty() || this.aggregateParentResources)) {
            Enumeration<URL> res = this.parent.getResources(nm);
            while (res.hasMoreElements()) {
                resources.add(res.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ClassLoaderState getState() {
        ClassLoaderState state = this.state;
        if (state == null) {
            QuarkusClassLoader quarkusClassLoader = this;
            synchronized (quarkusClassLoader) {
                state = this.state;
                if (state == null) {
                    HashMap<String, ArrayList<ClassPathElement>> elementMap = new HashMap<String, ArrayList<ClassPathElement>>();
                    for (ClassPathElement classPathElement : this.elements) {
                        for (String string : classPathElement.getProvidedResources()) {
                            if (string.startsWith("/")) {
                                throw new RuntimeException("Resources cannot start with /, " + string + " is incorrect provided by " + classPathElement);
                            }
                            ArrayList<ClassPathElement> list = (ArrayList<ClassPathElement>)elementMap.get(string);
                            if (list == null) {
                                list = new ArrayList<ClassPathElement>();
                                elementMap.put(string, list);
                            }
                            list.add(classPathElement);
                        }
                    }
                    HashMap<String, ClassPathElement[]> finalElements = new HashMap<String, ClassPathElement[]>();
                    for (Map.Entry entry : elementMap.entrySet()) {
                        void var7_17;
                        List list = (List)entry.getValue();
                        if (!this.lesserPriorityElements.isEmpty() && list.size() > 1) {
                            ArrayList<ClassPathElement> entryNormalPriorityElements = new ArrayList<ClassPathElement>(list.size());
                            ArrayList<ClassPathElement> entryLesserPriorityElements = new ArrayList<ClassPathElement>(list.size());
                            for (ClassPathElement classPathElement : list) {
                                if (this.lesserPriorityElements.contains(classPathElement)) {
                                    entryLesserPriorityElements.add(classPathElement);
                                    continue;
                                }
                                entryNormalPriorityElements.add(classPathElement);
                            }
                            ArrayList<ClassPathElement> arrayList = new ArrayList<ClassPathElement>(list.size());
                            arrayList.addAll(entryNormalPriorityElements);
                            arrayList.addAll(entryLesserPriorityElements);
                        }
                        finalElements.put((String)entry.getKey(), var7_17.toArray(new ClassPathElement[var7_17.size()]));
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    for (ClassPathElement classPathElement : this.bannedElements) {
                        hashSet.addAll(classPathElement.getProvidedResources());
                    }
                    HashSet<String> hashSet2 = new HashSet<String>();
                    for (ClassPathElement i : this.parentFirstElements) {
                        hashSet2.addAll(i.getProvidedResources());
                    }
                    this.state = new ClassLoaderState(finalElements, hashSet, hashSet2);
                    return this.state;
                }
            }
        }
        return state;
    }

    @Override
    public URL getResource(String nm) {
        String name = this.sanitizeName(nm);
        ClassLoaderState state = this.getState();
        if (state.bannedResources.contains(name)) {
            return null;
        }
        for (ClassPathElement i : this.elements) {
            ClassPathResource res = i.getResource(name);
            if (res == null) continue;
            return res.getUrl();
        }
        return this.parent.getResource(nm);
    }

    @Override
    public InputStream getResourceAsStream(String nm) {
        String name = this.sanitizeName(nm);
        ClassLoaderState state = this.getState();
        if (state.bannedResources.contains(name)) {
            return null;
        }
        for (ClassPathElement i : this.elements) {
            ClassPathResource res = i.getResource(name);
            if (res == null) continue;
            return new ByteArrayInputStream(res.getData());
        }
        return this.parent.getResourceAsStream(nm);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassPathElement classPathElement;
        ClassPathResource classPathElementResource;
        ClassPathElement[] resource;
        boolean parentFirst;
        String resourceName;
        ClassLoaderState state;
        boolean interrupted;
        block17: {
            if (name.startsWith(JAVA)) {
                return this.parent.loadClass(name);
            }
            interrupted = Thread.interrupted();
            try {
                state = this.getState();
                Object object = this.getClassLoadingLock(name);
                // MONITORENTER : object
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    Class<?> clazz = c;
                    // MONITOREXIT : object
                    if (!interrupted) return clazz;
                    Thread.currentThread().interrupt();
                    return clazz;
                }
                resourceName = this.sanitizeName(name).replace(".", "/") + ".class";
                parentFirst = this.parentFirst(resourceName, state);
                if (!state.bannedResources.contains(resourceName)) break block17;
            }
            catch (Throwable throwable) {
                if (!interrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
            throw new ClassNotFoundException(name);
        }
        if (parentFirst) {
            try {
                Class<?> clazz = this.parent.loadClass(name);
                // MONITOREXIT : object
                if (!interrupted) return clazz;
                Thread.currentThread().interrupt();
                return clazz;
            }
            catch (ClassNotFoundException ignore) {
                log.tracef("Class %s not found in parent first load from %s", (Object)name, (Object)this.parent);
            }
        }
        if ((resource = state.loadableResources.get(resourceName)) != null && (classPathElementResource = (classPathElement = resource[0]).getResource(resourceName)) != null) {
            byte[] data = classPathElementResource.getData();
            List<BiFunction<String, ClassVisitor, ClassVisitor>> transformers = this.bytecodeTransformers.get(name);
            if (transformers != null) {
                data = this.handleTransform(name, data, transformers);
            }
            this.definePackage(name, classPathElement);
            Class<?> clazz = this.defineClass(name, data, 0, data.length, this.protectionDomains.computeIfAbsent(classPathElement, ce -> ce.getProtectionDomain(this)));
            // MONITOREXIT : object
            if (!interrupted) return clazz;
            Thread.currentThread().interrupt();
            return clazz;
        }
        if (!parentFirst) {
            Class<?> clazz = this.parent.loadClass(name);
            // MONITOREXIT : object
            if (!interrupted) return clazz;
            Thread.currentThread().interrupt();
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String name, ClassPathElement classPathElement) {
        String pkgName = this.getPackageNameFromClassName(name);
        if (pkgName != null && this.getPackage(pkgName) == null) {
            Object object = this.getClassLoadingLock(pkgName);
            synchronized (object) {
                if (this.getPackage(pkgName) == null) {
                    Manifest mf = classPathElement.getManifest();
                    if (mf != null) {
                        Attributes ma = mf.getMainAttributes();
                        this.definePackage(pkgName, ma.getValue(Attributes.Name.SPECIFICATION_TITLE), ma.getValue(Attributes.Name.SPECIFICATION_VERSION), ma.getValue(Attributes.Name.SPECIFICATION_VENDOR), ma.getValue(Attributes.Name.IMPLEMENTATION_TITLE), ma.getValue(Attributes.Name.IMPLEMENTATION_VERSION), ma.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), null);
                        return;
                    }
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    private byte[] handleTransform(String name, byte[] bytes, List<BiFunction<String, ClassVisitor, ClassVisitor>> transformers) {
        ClassWriter writer;
        ClassReader cr = new ClassReader(bytes);
        ClassWriter visitor = writer = new ClassWriter(cr, 3){

            protected ClassLoader getClassLoader() {
                return QuarkusClassLoader.this.transformerClassLoader;
            }
        };
        for (BiFunction<String, ClassVisitor, ClassVisitor> i : transformers) {
            visitor = i.apply(name, (ClassVisitor)visitor);
        }
        cr.accept((ClassVisitor)visitor, 0);
        return writer.toByteArray();
    }

    public Class<?> visibleDefineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return super.defineClass(name, b, off, len);
    }

    @Override
    public void close() {
        for (ClassPathElement element : this.elements) {
            try {
                ClassPathElement ignored = element;
                Throwable throwable = null;
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                ignored.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close " + element), (Throwable)e);
            }
        }
    }

    public String toString() {
        return "QuarkusClassLoader:" + this.name;
    }

    static {
        QuarkusClassLoader.registerAsParallelCapable();
    }

    static final class ClassLoaderState {
        final Map<String, ClassPathElement[]> loadableResources;
        final Set<String> bannedResources;
        final Set<String> parentFirstResources;

        ClassLoaderState(Map<String, ClassPathElement[]> loadableResources, Set<String> bannedResources, Set<String> parentFirstResources) {
            this.loadableResources = loadableResources;
            this.bannedResources = bannedResources;
            this.parentFirstResources = parentFirstResources;
        }
    }

    public static class Builder {
        final String name;
        final ClassLoader parent;
        final List<ClassPathElement> elements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> bannedElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> parentFirstElements = new ArrayList<ClassPathElement>();
        final List<ClassPathElement> lesserPriorityElements = new ArrayList<ClassPathElement>();
        Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers = Collections.emptyMap();
        final boolean parentFirst;
        MemoryClassPathElement resettableElement;
        private volatile ClassLoader transformerClassLoader;
        boolean aggregateParentResources;

        public Builder(String name, ClassLoader parent, boolean parentFirst) {
            this.name = name;
            this.parent = parent;
            this.parentFirst = parentFirst;
        }

        public Builder addElement(ClassPathElement element) {
            log.debugf("Adding elements %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.elements.add(element);
            return this;
        }

        public Builder setResettableElement(MemoryClassPathElement resettableElement) {
            this.resettableElement = resettableElement;
            return this;
        }

        public Builder addParentFirstElement(ClassPathElement element) {
            log.debugf("Adding parent first element %s to QuarkusClassLoader %s", (Object)element, (Object)this.name);
            this.parentFirstElements.add(element);
            return this;
        }

        public Builder addBannedElement(ClassPathElement element) {
            this.bannedElements.add(element);
            return this;
        }

        public Builder addLesserPriorityElement(ClassPathElement element) {
            this.lesserPriorityElements.add(element);
            return this;
        }

        public void setBytecodeTransformers(Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers) {
            this.bytecodeTransformers = bytecodeTransformers == null ? Collections.emptyMap() : bytecodeTransformers;
        }

        public Builder setAggregateParentResources(boolean aggregateParentResources) {
            this.aggregateParentResources = aggregateParentResources;
            return this;
        }

        public Builder setTransformerClassLoader(ClassLoader transformerClassLoader) {
            this.transformerClassLoader = transformerClassLoader;
            return this;
        }

        public QuarkusClassLoader build() {
            if (this.resettableElement != null && !this.elements.contains(this.resettableElement)) {
                this.elements.add(0, this.resettableElement);
            }
            return new QuarkusClassLoader(this);
        }
    }
}

