/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.GACT;

public interface ArtifactKey {
    public static ArtifactKey fromString(String s) {
        return GACT.fromString(s);
    }

    public static ArtifactKey ga(String groupId, String artifactId) {
        return new GACT(groupId, artifactId);
    }

    public static ArtifactKey gac(String groupId, String artifactId, String classifier) {
        return new GACT(groupId, artifactId, classifier);
    }

    public static ArtifactKey gact(String groupId, String artifactId, String classifier, String type) {
        return new GACT(groupId, artifactId, classifier, type);
    }

    public String getGroupId();

    public String getArtifactId();

    public String getClassifier();

    public String getType();

    default public String toGacString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getGroupId()).append(':').append(this.getArtifactId());
        if (!this.getClassifier().isEmpty()) {
            buf.append(':').append(this.getClassifier());
        }
        return buf.toString();
    }
}

