/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BootstrapUtils {
    private static Pattern splitByWs;

    public static String[] splitByWhitespace(String s) {
        if (s == null) {
            return null;
        }
        if (splitByWs == null) {
            splitByWs = Pattern.compile("\\s+");
        }
        return splitByWs.split(s);
    }

    public static ArtifactKey[] parseDependencyCondition(String s) {
        String[] strArr = BootstrapUtils.splitByWhitespace(s);
        if (strArr == null) {
            return null;
        }
        ArtifactKey[] keys = new ArtifactKey[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            keys[i] = GACT.fromString(strArr[i]);
        }
        return keys;
    }

    public static AppModel convert(ApplicationModel appModel) {
        if (appModel instanceof AppModel) {
            return (AppModel)appModel;
        }
        AppModel.Builder builder = new AppModel.Builder();
        ResolvedDependency resolvedArtifact = appModel.getAppArtifact();
        AppArtifact appArtifact = new AppArtifact(resolvedArtifact.getGroupId(), resolvedArtifact.getArtifactId(), resolvedArtifact.getClassifier(), resolvedArtifact.getType(), resolvedArtifact.getVersion(), appModel.getApplicationModule(), resolvedArtifact.getScope(), resolvedArtifact.getFlags());
        if (appModel.getAppArtifact().isResolved()) {
            appArtifact.setPaths(PathsCollection.from(appModel.getAppArtifact().getResolvedPaths()));
        }
        builder.setAppArtifact(appArtifact);
        builder.setCapabilitiesContracts(appModel.getExtensionCapabilities().stream().map(c -> new CapabilityContract(c.getExtension(), new ArrayList<String>(c.getProvidesCapabilities()), new ArrayList<String>(c.getRequiresCapabilities()))).collect(Collectors.toMap(CapabilityContract::getExtension, Function.identity())));
        builder.setPlatformImports(appModel.getPlatforms());
        appModel.getDependencies().forEach(d -> {
            AppArtifact a = new AppArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion(), d.getWorkspaceModule(), d.getScope(), d.getFlags());
            a.setPaths(d.getResolvedPaths() == null ? PathsCollection.of(new Path[0]) : PathsCollection.from(d.getResolvedPaths()));
            builder.addDependency(new AppDependency(a, d.getScope(), d.getFlags()));
            if (d.isFlagSet(1024)) {
                builder.addLesserPriorityArtifact(a.getKey());
            }
            if (d.isClassLoaderParentFirst()) {
                builder.addParentFirstArtifact(a.getKey());
            }
            if (d.isFlagSet(512)) {
                builder.addRunnerParentFirstArtifact(a.getKey());
            }
        });
        appModel.getReloadableWorkspaceDependencies().forEach(k -> builder.addLocalProjectArtifact(new AppArtifactKey(k.getGroupId(), k.getArtifactId(), k.getClassifier(), k.getType())));
        return builder.build();
    }

    public static void exportModel(ApplicationModel model, boolean test) throws AppModelResolverException, IOException {
        Path serializedModel = BootstrapUtils.serializeAppModel(model, test);
        System.setProperty(test ? "quarkus-internal-test.serialized-app-model.path" : "quarkus-internal.serialized-app-model.path", serializedModel.toString());
    }

    public static Path serializeAppModel(ApplicationModel model, boolean test) throws AppModelResolverException, IOException {
        Path serializedModel = File.createTempFile("quarkus-" + (test ? "test-" : "") + "app-model", ".dat").toPath();
        BootstrapUtils.serializeAppModel(model, serializedModel);
        return serializedModel;
    }

    public static void serializeAppModel(ApplicationModel model, Path serializedModel) throws IOException {
        Files.createDirectories(serializedModel.getParent(), new FileAttribute[0]);
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(model);
        }
    }

    public static Path serializeQuarkusModel(ApplicationModel model) throws IOException {
        Path serializedModel = File.createTempFile("quarkus-model", ".dat").toPath();
        BootstrapUtils.serializeAppModel(model, serializedModel);
        return serializedModel;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ApplicationModel deserializeQuarkusModel(Path modelPath) throws AppModelResolverException {
        if (Files.exists(modelPath, new LinkOption[0])) {
            try (InputStream existing = Files.newInputStream(modelPath, new OpenOption[0]);){
                ApplicationModel applicationModel;
                try (ObjectInputStream object = new ObjectInputStream(existing);){
                    ApplicationModel model = (ApplicationModel)object.readObject();
                    IoUtils.recursiveDelete(modelPath);
                    applicationModel = model;
                }
                return applicationModel;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new AppModelResolverException("Failed to deserialize quarkus model", e);
            }
        }
        throw new AppModelResolverException("Unable to locate quarkus model");
    }

    public static Path resolveSerializedAppModelPath(Path projectBuildDir) {
        return projectBuildDir.resolve("quarkus").resolve("bootstrap").resolve("dev-app-model.dat");
    }
}

