/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.artemis.core.runtime.health.ArtemisHealthSupport;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ServerLocatorHealthCheck
implements HealthCheck {
    private final HashMap<String, ServerLocator> serverLocators = new HashMap();

    public ServerLocatorHealthCheck(ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, ArtemisHealthSupport support) {
        HashSet<String> includedNames = new HashSet<String>(support.getConfiguredNames());
        includedNames.removeAll(support.getExcludedNames());
        this.processKnownBeans(runtimeConfigs, includedNames);
        this.processArcBeans(runtimeConfigs, buildTimeConfigs);
    }

    private void processKnownBeans(ArtemisRuntimeConfigs runtimeConfigs, HashSet<String> includedNames) {
        for (String name : includedNames) {
            if (runtimeConfigs.getAllConfigs().get(name) == null) continue;
            Object identifier = ArtemisUtil.isDefault(name) ? Default.Literal.INSTANCE : Identifier.Literal.of((String)name);
            ServerLocator locator = (ServerLocator)Arc.container().instance(ServerLocator.class, new Annotation[]{identifier}).get();
            if (locator == null) continue;
            this.serverLocators.put(name, locator);
        }
    }

    private void processArcBeans(ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs) {
        if (runtimeConfigs.getHealthExternalEnabled()) {
            HashSet<String> namesToIgnore = new HashSet<String>(runtimeConfigs.getAllConfigs().keySet());
            namesToIgnore.addAll(buildTimeConfigs.getAllConfigs().keySet());
            Map<String, ServerLocator> locatorNamesFromArc = ArtemisUtil.extractIdentifiers(ServerLocator.class, namesToIgnore);
            for (Map.Entry<String, ServerLocator> entry : locatorNamesFromArc.entrySet()) {
                ServerLocator locator = entry.getValue();
                if (locator == null) continue;
                this.serverLocators.put(entry.getKey(), locator);
            }
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Artemis Core health check").up();
        for (Map.Entry<String, ServerLocator> entry : this.serverLocators.entrySet()) {
            String name = entry.getKey();
            try {
                ClientSessionFactory ignored = entry.getValue().createSessionFactory();
                try {
                    builder.withData(name, "UP");
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                builder.withData(name, "DOWN").down();
            }
        }
        return builder.build();
    }
}

